/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.ParquetRunLengthBitPackingHybridEncoder;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.LongColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.bytes.BytesInput;

public final class BooleanColumnValuesWriter
extends AbstractColumnValuesWriter {
    private final ParquetRunLengthBitPackingHybridEncoder booleanWriter = new ParquetRunLengthBitPackingHybridEncoder(1);

    public BooleanColumnValuesWriter(int columnIndex, int level, boolean collection, boolean filtered) {
        super(columnIndex, level, collection, filtered);
    }

    @Override
    protected void addValue(ATypeTag tag, IValueReference value) throws IOException {
        byte booleanValue = value.getByteArray()[value.getStartOffset()];
        this.booleanWriter.writeInt(booleanValue);
        this.filterWriter.addLong(booleanValue);
    }

    @Override
    protected void resetValues() {
        this.booleanWriter.reset();
    }

    @Override
    protected BytesInput getBytes() throws IOException {
        return this.booleanWriter.toBytes();
    }

    @Override
    protected int getValuesEstimatedSize() {
        return this.booleanWriter.getEstimatedSize();
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return 1;
    }

    @Override
    protected int getValuesAllocatedSize() {
        return this.booleanWriter.getAllocatedSize();
    }

    @Override
    protected void addValue(IColumnValuesReader reader) throws IOException {
        int value = reader.getBoolean() ? 1 : 0;
        this.booleanWriter.writeInt(value);
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return new LongColumnFilterWriter();
    }

    @Override
    protected void closeValues() {
        this.booleanWriter.close();
    }

    @Override
    protected ATypeTag getTypeTag() {
        return ATypeTag.BOOLEAN;
    }
}

