/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import java.io.IOException;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.encoder.ParquetDeltaByteArrayWriter;
import org.apache.asterix.column.bytes.encoder.ParquetPlainVariableLengthValuesWriter;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.writer.AbstractColumnValuesWriter;
import org.apache.asterix.column.values.writer.filters.AbstractColumnFilterWriter;
import org.apache.asterix.column.values.writer.filters.StringColumnFilterWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;

public class StringColumnValuesWriter
extends AbstractColumnValuesWriter {
    private final AbstractParquetValuesWriter stringWriter;
    private final boolean skipLengthBytes;

    public StringColumnValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef, int columnIndex, int level, boolean collection, boolean filtered) {
        this(columnIndex, level, collection, filtered, true, filtered ? new ParquetDeltaByteArrayWriter(multiPageOpRef) : new ParquetPlainVariableLengthValuesWriter(multiPageOpRef));
    }

    protected StringColumnValuesWriter(int columnIndex, int level, boolean collection, boolean filtered, boolean skipLengthBytes, AbstractParquetValuesWriter stringWriter) {
        super(columnIndex, level, collection, filtered);
        this.stringWriter = stringWriter;
        this.skipLengthBytes = skipLengthBytes;
    }

    @Override
    protected final void addValue(ATypeTag tag, IValueReference value) throws IOException {
        this.stringWriter.writeBytes(value, this.skipLengthBytes);
        this.filterWriter.addValue(value);
    }

    @Override
    protected final void resetValues() throws HyracksDataException {
        this.stringWriter.reset();
    }

    @Override
    protected final BytesInput getBytes() throws IOException {
        return this.stringWriter.getBytes();
    }

    @Override
    protected final int getValuesEstimatedSize() {
        return this.stringWriter.getEstimatedSize();
    }

    @Override
    protected int calculateEstimatedSize(int length) {
        return this.stringWriter.calculateEstimatedSize(length);
    }

    @Override
    protected final int getValuesAllocatedSize() {
        return this.stringWriter.getAllocatedSize();
    }

    @Override
    protected final void addValue(IColumnValuesReader reader) throws IOException {
        IValueReference value = reader.getBytes();
        this.stringWriter.writeBytes(value, this.skipLengthBytes);
        this.filterWriter.addValue(value);
    }

    @Override
    protected AbstractColumnFilterWriter createFilter() {
        return new StringColumnFilterWriter();
    }

    @Override
    protected final void closeValues() {
        this.stringWriter.close();
    }

    @Override
    protected ATypeTag getTypeTag() {
        return ATypeTag.STRING;
    }
}

