/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public final class ColumnMultiBufferProvider
implements IColumnBufferProvider {
    private final int columnIndex;
    private final IColumnReadMultiPageOp multiPageOp;
    private final Queue<ICachedPage> pages;
    private final LongSet pinnedPages;
    private int numberOfPages;
    private int startPage;
    private int startOffset;
    private int length;

    public ColumnMultiBufferProvider(int columnIndex, IColumnReadMultiPageOp multiPageOp, LongSet pinnedPages) {
        this.columnIndex = columnIndex;
        this.multiPageOp = multiPageOp;
        this.pinnedPages = pinnedPages;
        this.pages = new ArrayDeque<ICachedPage>();
    }

    @Override
    public void reset(ColumnBTreeReadLeafFrame frame) throws HyracksDataException {
        if (this.columnIndex >= frame.getNumberOfColumns()) {
            this.numberOfPages = 0;
            this.length = 0;
            return;
        }
        int offset = frame.getColumnOffset(this.columnIndex);
        this.startPage = frame.getPageId() + this.getColumnPageIndex(offset);
        this.startOffset = offset % this.multiPageOp.getPageSize();
        ByteBuffer firstPage = this.readNext().duplicate();
        firstPage.position(this.startOffset);
        this.length = firstPage.getInt();
        int remainingLength = this.length - firstPage.remaining();
        this.numberOfPages = (int)Math.ceil((double)remainingLength / (double)this.multiPageOp.getPageSize());
        this.startOffset += 4;
        this.length -= 4;
    }

    @Override
    public void readAll(Queue<ByteBuffer> buffers) throws HyracksDataException {
        ByteBuffer buffer = this.pages.peek().getBuffer().duplicate();
        buffer.clear();
        buffer.position(this.startOffset);
        buffers.add(buffer);
        for (int i = 0; i < this.numberOfPages; ++i) {
            buffer = this.readNext().duplicate();
            buffer.clear();
            buffers.add(buffer);
        }
        this.numberOfPages = 0;
    }

    @Override
    public void releaseAll() throws HyracksDataException {
        while (!this.pages.isEmpty()) {
            ICachedPage page = this.pages.poll();
            this.multiPageOp.unpin(page);
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteBuffer getBuffer() {
        throw new UnsupportedOperationException("Use readAll() for multi-buffer");
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    private ByteBuffer readNext() throws HyracksDataException {
        ICachedPage columnPage = this.multiPageOp.pin(this.startPage++);
        this.pages.add(columnPage);
        this.pinnedPages.add(((CachedPage)columnPage).getDiskPageId());
        return columnPage.getBuffer();
    }

    private int getColumnPageIndex(int columnOffset) {
        return (int)Math.floor((double)columnOffset / (double)this.multiPageOp.getPageSize());
    }
}

