/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.bulk;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.asterix.cloud.bulk.IBulkOperationCallBack;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.hyracks.control.nc.io.bulk.DeleteBulkOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteBulkCloudOperation
extends DeleteBulkOperation {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String bucket;
    private final ICloudClient cloudClient;
    private final IBulkOperationCallBack callBack;

    public DeleteBulkCloudOperation(IOManager ioManager, String bucket, ICloudClient cloudClient, IBulkOperationCallBack callBack) {
        super((IIOManager)ioManager);
        this.bucket = bucket;
        this.cloudClient = cloudClient;
        this.callBack = callBack;
    }

    public int performOperation() throws HyracksDataException {
        List<String> paths = this.fileReferences.stream().map(FileReference::getRelativePath).collect(Collectors.toList());
        if (paths.isEmpty()) {
            return 0;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bulk deleting: local: {}, cloud: {}", (Object)this.fileReferences, paths);
        }
        this.cloudClient.deleteObjects(this.bucket, paths);
        super.performOperation();
        this.callBack.call(this.fileReferences);
        return this.fileReferences.size();
    }
}

