/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.aws.s3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.asterix.cloud.clients.ICloudClient;
import org.apache.asterix.cloud.clients.IParallelDownloader;
import org.apache.asterix.cloud.clients.aws.s3.S3BufferedWriter;
import org.apache.asterix.cloud.clients.aws.s3.S3ClientConfig;
import org.apache.asterix.cloud.clients.aws.s3.S3ClientUtils;
import org.apache.asterix.cloud.clients.aws.s3.S3ParallelDownloader;
import org.apache.asterix.cloud.clients.profiler.CountRequestProfiler;
import org.apache.asterix.cloud.clients.profiler.IRequestProfiler;
import org.apache.asterix.cloud.clients.profiler.NoOpRequestProfiler;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.nc.io.IOManager;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3CloudClient
implements ICloudClient {
    private final S3ClientConfig config;
    private final S3Client s3Client;
    private final IRequestProfiler profiler;

    public S3CloudClient(S3ClientConfig config) {
        this(config, S3CloudClient.buildClient(config));
    }

    public S3CloudClient(S3ClientConfig config, S3Client s3Client) {
        this.config = config;
        this.s3Client = s3Client;
        long profilerInterval = config.getProfilerLogInterval();
        this.profiler = profilerInterval > 0L ? new CountRequestProfiler(profilerInterval) : NoOpRequestProfiler.INSTANCE;
    }

    @Override
    public ICloudBufferedWriter createBufferedWriter(String bucket, String path) {
        return new S3BufferedWriter(this.s3Client, this.profiler, bucket, path);
    }

    @Override
    public Set<String> listObjects(String bucket, String path, FilenameFilter filter) {
        this.profiler.objectsList();
        path = this.config.isLocalS3Provider() ? S3ClientUtils.encodeURI(path) : path;
        return this.filterAndGet(S3ClientUtils.listS3Objects(this.s3Client, bucket, path), filter);
    }

    @Override
    public int read(String bucket, String path, long offset, ByteBuffer buffer) throws HyracksDataException {
        this.profiler.objectGet();
        long readTo = offset + (long)buffer.remaining();
        GetObjectRequest rangeGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().range("bytes=" + offset + "-" + readTo).bucket(bucket).key(path).build();
        int totalRead = 0;
        int read = 0;
        try (ResponseInputStream response = this.s3Client.getObject(rangeGetObjectRequest);){
            while (buffer.remaining() > 0) {
                read = response.read(buffer.array(), buffer.position(), buffer.remaining());
                buffer.position(buffer.position() + read);
                totalRead += read;
            }
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
        if (buffer.remaining() != 0) {
            throw new IllegalStateException("Expected buffer remaining = 0, found: " + buffer.remaining());
        }
        return totalRead;
    }

    @Override
    public byte[] readAllBytes(String bucket, String path) throws HyracksDataException {
        byte[] byArray;
        block9: {
            this.profiler.objectGet();
            GetObjectRequest getReq = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(path).build();
            ResponseInputStream stream = this.s3Client.getObject(getReq);
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchKeyException e) {
                    return null;
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            stream.close();
        }
        return byArray;
    }

    @Override
    public InputStream getObjectStream(String bucket, String path) {
        this.profiler.objectGet();
        GetObjectRequest getReq = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(path).build();
        try {
            return this.s3Client.getObject(getReq);
        }
        catch (NoSuchKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void write(String bucket, String path, byte[] data) {
        this.profiler.objectWrite();
        PutObjectRequest putReq = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(path).build();
        this.s3Client.putObject(putReq, RequestBody.fromBytes((byte[])data));
    }

    @Override
    public void copy(String bucket, String srcPath, FileReference destPath) {
        srcPath = this.config.isLocalS3Provider() ? S3ClientUtils.encodeURI(srcPath) : srcPath;
        List<S3Object> objects = S3ClientUtils.listS3Objects(this.s3Client, bucket, srcPath);
        this.profiler.objectsList();
        for (S3Object object : objects) {
            this.profiler.objectCopy();
            String srcKey = object.key();
            String destKey = destPath.getChildPath(IoUtil.getFileNameFromPath((String)srcKey));
            CopyObjectRequest copyReq = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(bucket).sourceKey(srcKey).destinationBucket(bucket).destinationKey(destKey).build();
            this.s3Client.copyObject(copyReq);
        }
    }

    @Override
    public void deleteObjects(String bucket, Collection<String> paths) {
        if (paths.isEmpty()) {
            return;
        }
        ArrayList<ObjectIdentifier> objectIdentifiers = new ArrayList<ObjectIdentifier>();
        Iterator<String> pathIter = paths.iterator();
        ObjectIdentifier.Builder builder = ObjectIdentifier.builder();
        while (pathIter.hasNext()) {
            objectIdentifiers.clear();
            for (int i = 0; pathIter.hasNext() && i < 1000; ++i) {
                objectIdentifiers.add((ObjectIdentifier)builder.key(pathIter.next()).build());
            }
            Delete delete = (Delete)Delete.builder().objects(objectIdentifiers).build();
            DeleteObjectsRequest deleteReq = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucket).delete(delete).build();
            this.s3Client.deleteObjects(deleteReq);
            this.profiler.objectDelete();
        }
    }

    @Override
    public long getObjectSize(String bucket, String path) throws HyracksDataException {
        this.profiler.objectGet();
        try {
            return this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(path).build()).contentLength();
        }
        catch (NoSuchKeyException ex) {
            return 0L;
        }
        catch (Exception ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    @Override
    public boolean exists(String bucket, String path) throws HyracksDataException {
        this.profiler.objectGet();
        try {
            this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(bucket).key(path).build());
            return true;
        }
        catch (NoSuchKeyException ex) {
            return false;
        }
        catch (Exception ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    @Override
    public boolean isEmptyPrefix(String bucket, String path) throws HyracksDataException {
        this.profiler.objectsList();
        return S3ClientUtils.isEmptyPrefix(this.s3Client, bucket, path);
    }

    @Override
    public IParallelDownloader createParallelDownloader(String bucket, IOManager ioManager) {
        return new S3ParallelDownloader(bucket, ioManager, this.config, this.profiler);
    }

    @Override
    public JsonNode listAsJson(ObjectMapper objectMapper, String bucket) {
        List<S3Object> objects = S3ClientUtils.listS3Objects(this.s3Client, bucket, "/");
        ArrayNode objectsInfo = objectMapper.createArrayNode();
        objects.sort((x, y) -> String.CASE_INSENSITIVE_ORDER.compare(x.key(), y.key()));
        for (S3Object object : objects) {
            ObjectNode objectInfo = objectsInfo.addObject();
            objectInfo.put("path", object.key());
            objectInfo.put("size", object.size());
        }
        return objectsInfo;
    }

    @Override
    public void close() {
        this.s3Client.close();
    }

    private static S3Client buildClient(S3ClientConfig config) {
        S3ClientBuilder builder = S3Client.builder();
        builder.credentialsProvider(config.createCredentialsProvider());
        builder.region(Region.of((String)config.getRegion()));
        if (config.getEndpoint() != null && !config.getEndpoint().isEmpty()) {
            URI uri;
            try {
                uri = new URI(config.getEndpoint());
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
            builder.endpointOverride(uri);
        }
        return (S3Client)builder.build();
    }

    private Set<String> filterAndGet(List<S3Object> contents, FilenameFilter filter) {
        HashSet<String> files = new HashSet<String>();
        for (S3Object s3Object : contents) {
            String path = this.config.isLocalS3Provider() ? S3ClientUtils.decodeURI(s3Object.key()) : s3Object.key();
            if (!filter.accept(null, IoUtil.getFileNameFromPath((String)path))) continue;
            files.add(path);
        }
        return files;
    }
}

