/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.clients.aws.s3;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.asterix.cloud.clients.IParallelDownloader;
import org.apache.asterix.cloud.clients.aws.s3.S3ClientConfig;
import org.apache.asterix.cloud.clients.profiler.IRequestProfiler;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.control.nc.io.IOManager;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.CompletedDirectoryDownload;
import software.amazon.awssdk.transfer.s3.model.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.model.DirectoryDownload;
import software.amazon.awssdk.transfer.s3.model.DownloadDirectoryRequest;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.FailedFileDownload;
import software.amazon.awssdk.transfer.s3.model.FileDownload;

class S3ParallelDownloader
implements IParallelDownloader {
    private final String bucket;
    private final IOManager ioManager;
    private final S3AsyncClient s3AsyncClient;
    private final S3TransferManager transferManager;
    private final IRequestProfiler profiler;

    S3ParallelDownloader(String bucket, IOManager ioManager, S3ClientConfig config, IRequestProfiler profiler) {
        this.bucket = bucket;
        this.ioManager = ioManager;
        this.profiler = profiler;
        this.s3AsyncClient = S3ParallelDownloader.createAsyncClient(config);
        this.transferManager = this.createS3TransferManager(this.s3AsyncClient);
    }

    @Override
    public void downloadFiles(Collection<FileReference> toDownload) throws HyracksDataException {
        try {
            List<CompletableFuture<CompletedFileDownload>> downloads = this.startDownloadingFiles(toDownload);
            this.waitForFileDownloads(downloads);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public Collection<FileReference> downloadDirectories(Collection<FileReference> toDownload) throws HyracksDataException {
        Set<FileReference> failedFiles;
        List<CompletableFuture<CompletedDirectoryDownload>> downloads = this.startDownloadingDirectories(toDownload);
        try {
            failedFiles = this.waitForDirectoryDownloads(downloads);
        }
        catch (InterruptedException | ExecutionException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return failedFiles;
    }

    @Override
    public void close() {
        this.transferManager.close();
        this.s3AsyncClient.close();
    }

    private List<CompletableFuture<CompletedFileDownload>> startDownloadingFiles(Collection<FileReference> toDownload) throws IOException {
        ArrayList<CompletableFuture<CompletedFileDownload>> downloads = new ArrayList<CompletableFuture<CompletedFileDownload>>();
        for (FileReference fileReference : toDownload) {
            this.profiler.objectGet();
            FileUtils.createParentDirectories((File)fileReference.getFile());
            GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder();
            requestBuilder.bucket(this.bucket);
            requestBuilder.key(fileReference.getRelativePath());
            DownloadFileRequest.Builder builder = DownloadFileRequest.builder();
            builder.getObjectRequest((GetObjectRequest)requestBuilder.build());
            builder.destination(fileReference.getFile());
            FileDownload fileDownload = this.transferManager.downloadFile((DownloadFileRequest)builder.build());
            downloads.add(fileDownload.completionFuture());
        }
        return downloads;
    }

    private void waitForFileDownloads(List<CompletableFuture<CompletedFileDownload>> downloads) throws ExecutionException, InterruptedException {
        for (CompletableFuture<CompletedFileDownload> download : downloads) {
            download.get();
        }
    }

    private List<CompletableFuture<CompletedDirectoryDownload>> startDownloadingDirectories(Collection<FileReference> toDownload) {
        ArrayList<CompletableFuture<CompletedDirectoryDownload>> downloads = new ArrayList<CompletableFuture<CompletedDirectoryDownload>>();
        for (FileReference fileReference : toDownload) {
            DownloadDirectoryRequest.Builder builder = DownloadDirectoryRequest.builder();
            builder.bucket(this.bucket);
            builder.destination(fileReference.getFile().toPath());
            builder.listObjectsV2RequestTransformer(l -> l.prefix(fileReference.getRelativePath()));
            DirectoryDownload directoryDownload = this.transferManager.downloadDirectory((DownloadDirectoryRequest)builder.build());
            downloads.add(directoryDownload.completionFuture());
        }
        return downloads;
    }

    private Set<FileReference> waitForDirectoryDownloads(List<CompletableFuture<CompletedDirectoryDownload>> downloads) throws ExecutionException, InterruptedException, HyracksDataException {
        HashSet<FileReference> failedFiles = Collections.emptySet();
        for (CompletableFuture<CompletedDirectoryDownload> download : downloads) {
            this.profiler.objectMultipartDownload();
            download.join();
            CompletedDirectoryDownload completedDirectoryDownload = download.get();
            if (completedDirectoryDownload.failedTransfers().isEmpty()) continue;
            failedFiles = failedFiles.isEmpty() ? new HashSet<FileReference>() : failedFiles;
            for (FailedFileDownload failedFileDownload : completedDirectoryDownload.failedTransfers()) {
                FileReference failedFile = this.ioManager.resolve(failedFileDownload.request().getObjectRequest().key());
                failedFiles.add(failedFile);
            }
        }
        return failedFiles;
    }

    private static S3AsyncClient createAsyncClient(S3ClientConfig config) {
        if (config.isLocalS3Provider()) {
            return S3ParallelDownloader.createS3AsyncClient(config);
        }
        return S3ParallelDownloader.createS3CrtAsyncClient(config);
    }

    private static S3AsyncClient createS3AsyncClient(S3ClientConfig config) {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builder.credentialsProvider(config.createCredentialsProvider());
        builder.region(Region.of((String)config.getRegion()));
        if (config.getEndpoint() != null && !config.getEndpoint().isEmpty()) {
            builder.endpointOverride(URI.create(config.getEndpoint()));
        }
        return (S3AsyncClient)builder.build();
    }

    private static S3AsyncClient createS3CrtAsyncClient(S3ClientConfig config) {
        S3CrtAsyncClientBuilder builder = S3AsyncClient.crtBuilder();
        builder.credentialsProvider(config.createCredentialsProvider());
        builder.region(Region.of((String)config.getRegion()));
        if (config.getEndpoint() != null && !config.getEndpoint().isEmpty()) {
            builder.endpointOverride(URI.create(config.getEndpoint()));
        }
        return builder.build();
    }

    private S3TransferManager createS3TransferManager(S3AsyncClient s3AsyncClient) {
        return S3TransferManager.builder().s3Client(s3AsyncClient).build();
    }
}

