/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFamily;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FieldHashPartitionComputerFamily
implements ITuplePartitionComputerFamily {
    private static final long serialVersionUID = 1L;
    private final int[] hashFields;
    private final IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories;

    public FieldHashPartitionComputerFamily(int[] hashFields, IBinaryHashFunctionFamily[] hashFunctionGeneratorFactories) {
        this.hashFields = hashFields;
        this.hashFunctionGeneratorFactories = hashFunctionGeneratorFactories;
    }

    public ITuplePartitionComputer createPartitioner(int seed) {
        final IBinaryHashFunction[] hashFunctions = new IBinaryHashFunction[this.hashFunctionGeneratorFactories.length];
        for (int i = 0; i < this.hashFunctionGeneratorFactories.length; ++i) {
            hashFunctions[i] = this.hashFunctionGeneratorFactories[i].createBinaryHashFunction(seed);
        }
        return new ITuplePartitionComputer(){

            public int partition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                int h = 0;
                int startOffset = accessor.getTupleStartOffset(tIndex);
                int slotLength = accessor.getFieldSlotsLength();
                for (int j = 0; j < FieldHashPartitionComputerFamily.this.hashFields.length; ++j) {
                    int fIdx = FieldHashPartitionComputerFamily.this.hashFields[j];
                    IBinaryHashFunction hashFn = hashFunctions[j];
                    int fStart = accessor.getFieldStartOffset(tIndex, fIdx);
                    int fEnd = accessor.getFieldEndOffset(tIndex, fIdx);
                    int fh = hashFn.hash(accessor.getBuffer().array(), startOffset + slotLength + fStart, fEnd - fStart);
                    h += fh;
                }
                if (h < 0) {
                    h = -(h + 1);
                }
                return h % nParts;
            }
        };
    }
}

