/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.IoOperationExecutor;

public abstract class AbstractAsynchronousScheduler
implements ILSMIOOperationScheduler,
Closeable {
    protected final ExecutorService executor;
    private final int maxNumFlushes;
    protected final Map<String, ILSMIOOperation> runningFlushOperations = new HashMap<String, ILSMIOOperation>();
    protected final Map<String, ILSMIOOperation> runningReplicateOperations = new HashMap<String, ILSMIOOperation>();
    protected final Deque<ILSMIOOperation> waitingFlushOperations = new ArrayDeque<ILSMIOOperation>();
    protected final Deque<ILSMIOOperation> waitingMergeOperations = new ArrayDeque<ILSMIOOperation>();
    protected final Deque<ILSMIOOperation> waitingReplicateOperations = new ArrayDeque<ILSMIOOperation>();
    protected final Map<String, Throwable> failedGroups = new HashMap<String, Throwable>();

    public AbstractAsynchronousScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback, int maxNumFlushes) {
        this.executor = new IoOperationExecutor(threadFactory, this, callback, this.runningFlushOperations, this.failedGroups);
        this.maxNumFlushes = maxNumFlushes;
    }

    @Override
    public void scheduleOperation(ILSMIOOperation operation) {
        switch (operation.getIOOpertionType()) {
            case FLUSH: {
                this.scheduleFlush(operation);
                break;
            }
            case MERGE: {
                this.scheduleMerge(operation);
                break;
            }
            case REPLICATE: {
                this.scheduleReplicate(operation);
                break;
            }
            case NOOP: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + operation.getIOOpertionType());
            }
        }
    }

    @Override
    public void completeOperation(ILSMIOOperation operation) throws HyracksDataException {
        switch (operation.getIOOpertionType()) {
            case FLUSH: {
                this.completeFlush(operation);
                break;
            }
            case MERGE: {
                this.completeMerge(operation);
                break;
            }
            case REPLICATE: {
                this.completeReplicate(operation);
                break;
            }
            case NOOP: {
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + operation.getIOOpertionType());
            }
        }
    }

    protected abstract void scheduleMerge(ILSMIOOperation var1);

    protected abstract void completeMerge(ILSMIOOperation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleFlush(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.checkFailedFlush(operation)) {
                return;
            }
            if (this.runningFlushOperations.size() >= this.maxNumFlushes || this.runningFlushOperations.containsKey(id)) {
                this.waitingFlushOperations.add(operation);
            } else {
                this.runningFlushOperations.put(id, operation);
                this.executor.submit(operation);
            }
        }
    }

    private boolean checkFailedFlush(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        if (this.failedGroups.containsKey(id)) {
            operation.setStatus(ILSMIOOperation.LSMIOOperationStatus.FAILURE);
            operation.setFailure(new RuntimeException("Operation group " + id + " has permanently failed", this.failedGroups.get(id)));
            operation.complete();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeFlush(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            ILSMIOOperation top;
            this.runningFlushOperations.remove(id);
            for (ILSMIOOperation flushOp : this.waitingFlushOperations) {
                String flushOpId = flushOp.getIndexIdentifier();
                if (this.runningFlushOperations.size() >= this.maxNumFlushes) break;
                if (this.runningFlushOperations.containsKey(flushOpId) || flushOp.isCompleted() || this.checkFailedFlush(flushOp)) continue;
                this.runningFlushOperations.put(flushOpId, flushOp);
                this.executor.submit(flushOp);
            }
            while (!this.waitingFlushOperations.isEmpty() && ((top = this.waitingFlushOperations.peek()).isCompleted() || this.runningFlushOperations.get(top.getIndexIdentifier()) == top)) {
                this.waitingFlushOperations.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReplicate(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            if (this.runningReplicateOperations.size() >= this.maxNumFlushes || this.runningReplicateOperations.containsKey(id)) {
                this.waitingReplicateOperations.add(operation);
            } else {
                this.runningReplicateOperations.put(id, operation);
                this.executor.submit(operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeReplicate(ILSMIOOperation operation) {
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            ILSMIOOperation top;
            this.runningReplicateOperations.remove(id);
            for (ILSMIOOperation replicateOp : this.waitingReplicateOperations) {
                String replicateOpId = replicateOp.getIndexIdentifier();
                if (this.runningReplicateOperations.size() >= this.maxNumFlushes) break;
                if (this.runningReplicateOperations.containsKey(replicateOpId) || replicateOp.isCompleted()) continue;
                this.runningReplicateOperations.put(replicateOpId, replicateOp);
                this.executor.submit(replicateOp);
            }
            while (!this.waitingReplicateOperations.isEmpty() && ((top = this.waitingReplicateOperations.peek()).isCompleted() || this.runningReplicateOperations.get(top.getIndexIdentifier()) == top)) {
                this.waitingReplicateOperations.poll();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
    }
}

