/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.FileHandle;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HandleListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ListResponse<FileHandle> response = new ListResponse();
    private FileHandle handle;

    private HandleListHandler() {
    }

    protected static ListResponse<FileHandle> getHandleList(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        HandleListHandler handler = new HandleListHandler();
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Handle".equals(localName)) {
            this.handle = new FileHandle();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Handle".equals(currentNode)) {
            this.response.getResults().add(this.handle);
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            }
        } else if ("Handle".equals(parentNode)) {
            try {
                this.setHandleProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    private void setHandleProperties(String currentNode, String value) throws ParseException {
        if ("HandleId".equals(currentNode)) {
            this.handle.setHandleID(value);
        } else if ("Path".equals(currentNode)) {
            this.handle.setPath(value);
        } else if ("FileId".equals(currentNode)) {
            this.handle.setFileID(value);
        } else if ("ParentId".equals(currentNode)) {
            this.handle.setParentFileID(value);
        } else if ("SessionId".equals(currentNode)) {
            this.handle.setSessionID(value);
        } else if ("ClientIp".equals(currentNode)) {
            this.handle.setClientIP(value);
        } else if ("OpenTime".equals(currentNode)) {
            this.handle.setOpenTime(value);
        } else if ("LastReconnectElement".equals(currentNode)) {
            this.handle.setLastReconnectTime(value);
        }
    }
}

