/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.ipc.security.NetworkSecurityManager;

public class RMIClientFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = -3874278041718817394L;
    private final INetworkSecurityConfig config;
    private transient SocketFactory socketFactory;

    private RMIClientFactory(INetworkSecurityConfig config) {
        this.config = config;
    }

    public static RMIClientSocketFactory getSocketFactory(INetworkSecurityManager securityManager) {
        INetworkSecurityConfig config = securityManager.getConfiguration();
        if (config.isSslEnabled()) {
            return new RMIClientFactory(config);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientFactory rMIClientFactory = this;
        synchronized (rMIClientFactory) {
            if (this.socketFactory == null) {
                this.socketFactory = this.config.isSslEnabled() ? new RMITrustedClientSSLSocketFactory(this.config) : SocketFactory.getDefault();
            }
        }
        return this.socketFactory.createSocket(host, port);
    }

    private static class RMITrustedClientSSLSocketFactory
    extends SSLSocketFactory {
        protected SSLSocketFactory factory;

        public RMITrustedClientSSLSocketFactory(INetworkSecurityConfig config) {
            this.factory = NetworkSecurityManager.newSSLContext((INetworkSecurityConfig)config).getSocketFactory();
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.factory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.factory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.factory.createSocket(address, port, localAddress, localPort);
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.factory.createSocket(socket, host, port, autoClose);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.factory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

