/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DependencyFullyQualifiedName;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.DatasetEntity;
import org.apache.asterix.metadata.entities.DependencyKind;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ViewDetails
implements IDatasetDetails {
    private static final long serialVersionUID = 2L;
    public static List<DependencyKind> DEPENDENCIES_SCHEMA = Arrays.asList(DependencyKind.DATASET, DependencyKind.FUNCTION, DependencyKind.TYPE, DependencyKind.SYNONYM);
    private final String viewBody;
    private final List<List<DependencyFullyQualifiedName>> dependencies;
    private final Boolean defaultNull;
    private final String datetimeFormat;
    private final String dateFormat;
    private final String timeFormat;
    private final List<String> primaryKeyFields;
    private final List<ForeignKey> foreignKeys;

    public ViewDetails(String viewBody, List<List<DependencyFullyQualifiedName>> dependencies, Boolean defaultNull, List<String> primaryKeyFields, List<ForeignKey> foreignKeys, String datetimeFormat, String dateFormat, String timeFormat) {
        this.viewBody = Objects.requireNonNull(viewBody);
        this.dependencies = Objects.requireNonNull(dependencies);
        this.defaultNull = defaultNull;
        this.primaryKeyFields = primaryKeyFields;
        this.foreignKeys = foreignKeys;
        this.datetimeFormat = datetimeFormat;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
    }

    @Override
    public DatasetConfig.DatasetType getDatasetType() {
        return DatasetConfig.DatasetType.VIEW;
    }

    public String getViewBody() {
        return this.viewBody;
    }

    public List<List<DependencyFullyQualifiedName>> getDependencies() {
        return this.dependencies;
    }

    public Boolean getDefaultNull() {
        return this.defaultNull;
    }

    public List<String> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public String getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void writeDatasetDetailsRecordType(DataOutput out, DatasetEntity datasetEntity) throws HyracksDataException {
        RecordBuilder viewRecordBuilder = new RecordBuilder();
        viewRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        ArrayBackedValueStorage fieldName = new ArrayBackedValueStorage();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
        ISerializerDeserializer nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
        fieldName.reset();
        aString.setValue("Definition");
        stringSerde.serialize((Object)aString, fieldName.getDataOutput());
        fieldValue.reset();
        aString.setValue(this.viewBody);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        if (!this.dependencies.isEmpty()) {
            fieldName.reset();
            aString.setValue("Dependencies");
            stringSerde.serialize((Object)aString, fieldName.getDataOutput());
            OrderedListBuilder dependenciesListBuilder = new OrderedListBuilder();
            OrderedListBuilder dependencyListBuilder = new OrderedListBuilder();
            OrderedListBuilder dependencyNameListBuilder = new OrderedListBuilder();
            boolean writeDatabase = datasetEntity.databaseNameIndex() >= 0;
            dependenciesListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            for (List list : this.dependencies) {
                dependencyListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
                AbstractTupleTranslator.writeDeps(dependencyListBuilder, itemValue, list, dependencyNameListBuilder, AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE, writeDatabase, aString, (ISerializerDeserializer<AString>)stringSerde);
                itemValue.reset();
                dependencyListBuilder.write(itemValue.getDataOutput(), true);
                dependenciesListBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            dependenciesListBuilder.write(fieldValue.getDataOutput(), true);
            viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        if (this.defaultNull != null && this.defaultNull.booleanValue()) {
            fieldName.reset();
            aString.setValue("Default");
            stringSerde.serialize((Object)aString, fieldName.getDataOutput());
            fieldValue.reset();
            nullSerde.serialize((Object)ANull.NULL, fieldValue.getDataOutput());
            viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        if (this.primaryKeyFields != null && !this.primaryKeyFields.isEmpty()) {
            fieldName.reset();
            aString.setValue("PrimaryKey");
            stringSerde.serialize((Object)aString, fieldName.getDataOutput());
            fieldValue.reset();
            OrderedListBuilder keyListBuilder = new OrderedListBuilder();
            OrderedListBuilder fieldPathListBuilder = new OrderedListBuilder();
            this.writeKeyFieldsList(this.primaryKeyFields, keyListBuilder, fieldPathListBuilder, aString, (ISerializerDeserializer<AString>)stringSerde, itemValue);
            keyListBuilder.write(fieldValue.getDataOutput(), true);
            viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
            fieldName.reset();
            aString.setValue("PrimaryKeyEnforced");
            stringSerde.serialize((Object)aString, fieldName.getDataOutput());
            fieldValue.reset();
            booleanSerde.serialize((Object)ABoolean.FALSE, fieldValue.getDataOutput());
            viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        if (this.foreignKeys != null && !this.foreignKeys.isEmpty()) {
            OrderedListBuilder foreignKeysListBuilder = new OrderedListBuilder();
            foreignKeysListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            RecordBuilder foreignKeyRecordBuilder = new RecordBuilder();
            OrderedListBuilder keyListBuilder = new OrderedListBuilder();
            OrderedListBuilder fieldPathListBuilder = new OrderedListBuilder();
            for (ForeignKey foreignKey : this.foreignKeys) {
                foreignKeyRecordBuilder.reset(RecordUtil.FULLY_OPEN_RECORD_TYPE);
                fieldName.reset();
                aString.setValue("ForeignKey");
                stringSerde.serialize((Object)aString, fieldName.getDataOutput());
                fieldValue.reset();
                this.writeKeyFieldsList(foreignKey.getForeignKeyFields(), keyListBuilder, fieldPathListBuilder, aString, (ISerializerDeserializer<AString>)stringSerde, itemValue);
                keyListBuilder.write(fieldValue.getDataOutput(), true);
                foreignKeyRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
                if (datasetEntity.databaseNameIndex() >= 0) {
                    fieldName.reset();
                    aString.setValue("RefDatabaseName");
                    stringSerde.serialize((Object)aString, fieldName.getDataOutput());
                    fieldValue.reset();
                    aString.setValue(foreignKey.getReferencedDatasetName().getDatabaseName());
                    stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
                    foreignKeyRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
                }
                fieldName.reset();
                aString.setValue("RefDataverseName");
                stringSerde.serialize((Object)aString, fieldName.getDataOutput());
                fieldValue.reset();
                aString.setValue(foreignKey.getReferencedDatasetName().getDataverseName().getCanonicalForm());
                stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
                foreignKeyRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
                fieldName.reset();
                aString.setValue("RefDatasetName");
                stringSerde.serialize((Object)aString, fieldName.getDataOutput());
                fieldValue.reset();
                aString.setValue(foreignKey.getReferencedDatasetName().getDatasetName());
                stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
                foreignKeyRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
                fieldName.reset();
                aString.setValue("IsEnforced");
                stringSerde.serialize((Object)aString, fieldName.getDataOutput());
                fieldValue.reset();
                booleanSerde.serialize((Object)ABoolean.FALSE, fieldValue.getDataOutput());
                foreignKeyRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
                fieldValue.reset();
                foreignKeyRecordBuilder.write(fieldValue.getDataOutput(), true);
                foreignKeysListBuilder.addItem((IValueReference)fieldValue);
            }
            fieldName.reset();
            aString.setValue("ForeignKeys");
            stringSerde.serialize((Object)aString, fieldName.getDataOutput());
            fieldValue.reset();
            foreignKeysListBuilder.write(fieldValue.getDataOutput(), true);
            viewRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
        }
        AbstractTupleTranslator.writeDateTimeFormats(this.datetimeFormat, this.dateFormat, this.timeFormat, (IARecordBuilder)viewRecordBuilder, aString, (ISerializerDeserializer<ANull>)nullSerde, (ISerializerDeserializer<AString>)stringSerde, fieldName, fieldValue, itemValue);
        viewRecordBuilder.write(out, true);
    }

    private void writeKeyFieldsList(List<String> keyFields, OrderedListBuilder keyListBuilder, OrderedListBuilder fieldListBuilder, AMutableString aString, ISerializerDeserializer<AString> stringSerde, ArrayBackedValueStorage itemValue) throws HyracksDataException {
        keyListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        for (String field : keyFields) {
            fieldListBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
            itemValue.reset();
            aString.setValue(field);
            stringSerde.serialize((Object)aString, itemValue.getDataOutput());
            fieldListBuilder.addItem((IValueReference)itemValue);
            itemValue.reset();
            fieldListBuilder.write(itemValue.getDataOutput(), true);
            keyListBuilder.addItem((IValueReference)itemValue);
        }
    }

    public static List<List<DependencyFullyQualifiedName>> createDependencies(List<DependencyFullyQualifiedName> datasetDependencies, List<DependencyFullyQualifiedName> functionDependencies, List<DependencyFullyQualifiedName> typeDependencies, List<DependencyFullyQualifiedName> synonymDependencies) {
        ArrayList<List<DependencyFullyQualifiedName>> depList = new ArrayList<List<DependencyFullyQualifiedName>>(DEPENDENCIES_SCHEMA.size());
        depList.add(datasetDependencies);
        depList.add(functionDependencies);
        depList.add(typeDependencies);
        if (!synonymDependencies.isEmpty()) {
            depList.add(synonymDependencies);
        }
        return depList;
    }

    public static final class ForeignKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> foreignKeyFields;
        private final DatasetFullyQualifiedName referencedDatasetName;

        public ForeignKey(List<String> foreignKeyFields, DatasetFullyQualifiedName referencedDatasetName) {
            this.foreignKeyFields = Objects.requireNonNull(foreignKeyFields);
            this.referencedDatasetName = Objects.requireNonNull(referencedDatasetName);
        }

        public List<String> getForeignKeyFields() {
            return this.foreignKeyFields;
        }

        public DatasetFullyQualifiedName getReferencedDatasetName() {
            return this.referencedDatasetName;
        }
    }
}

