/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.DependencyFullyQualifiedName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.DatasetEntity;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.dataset.DatasetFormatInfo;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.ViewDetails;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatasetTupleTranslator
extends AbstractTupleTranslator<Dataset> {
    protected final DatasetEntity datasetEntity;
    protected AMutableInt32 aInt32;
    protected AMutableInt64 aInt64;
    protected AMutableDouble aDouble;

    protected DatasetTupleTranslator(boolean getTuple, DatasetEntity datasetEntity) {
        super(getTuple, datasetEntity.getIndex(), datasetEntity.payloadPosition());
        this.datasetEntity = datasetEntity;
        if (getTuple) {
            this.aInt32 = new AMutableInt32(-1);
            this.aInt64 = new AMutableInt64(-1L);
            this.aDouble = new AMutableDouble(0.0);
        }
    }

    @Override
    protected Dataset createMetadataEntityFromARecord(ARecord datasetRecord) throws AlgebricksException {
        ARecordType recType = datasetRecord.getType();
        String dataverseCanonicalName = ((AString)datasetRecord.getValueByPos(this.datasetEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.datasetEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)datasetRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String datasetName = ((AString)datasetRecord.getValueByPos(this.datasetEntity.datasetNameIndex())).getStringValue();
        String typeName = ((AString)datasetRecord.getValueByPos(this.datasetEntity.datatypeNameIndex())).getStringValue();
        String typeDataverseCanonicalName = ((AString)datasetRecord.getValueByPos(this.datasetEntity.datatypeDataverseNameIndex())).getStringValue();
        DataverseName typeDataverseName = DataverseName.createFromCanonicalForm((String)typeDataverseCanonicalName);
        int typeDatabaseIdx = recType.getFieldIndex("DatatypeDatabaseName");
        String itemTypeDatabaseName = typeDatabaseIdx >= 0 ? ((AString)datasetRecord.getValueByPos(typeDatabaseIdx)).getStringValue() : MetadataUtil.databaseFor((DataverseName)typeDataverseName);
        DatasetConfig.DatasetType datasetType = DatasetConfig.DatasetType.valueOf((String)((AString)datasetRecord.getValueByPos(this.datasetEntity.datasetTypeIndex())).getStringValue());
        IDatasetDetails datasetDetails = null;
        int datasetId = ((AInt32)datasetRecord.getValueByPos(this.datasetEntity.datasetIdIndex())).getIntegerValue();
        int pendingOp = ((AInt32)datasetRecord.getValueByPos(this.datasetEntity.pendingOpIndex())).getIntegerValue();
        String nodeGroupName = ((AString)datasetRecord.getValueByPos(this.datasetEntity.groupNameIndex())).getStringValue();
        Pair<String, Map<String, String>> compactionPolicy = this.readCompactionPolicy(datasetType, datasetRecord);
        switch (datasetType) {
            case INTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(this.datasetEntity.internalDetailsIndex());
                InternalDatasetDetails.FileStructure fileStructure = InternalDatasetDetails.FileStructure.valueOf(((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue());
                InternalDatasetDetails.PartitioningStrategy partitioningStrategy = InternalDatasetDetails.PartitioningStrategy.valueOf(((AString)datasetDetailsRecord.getValueByPos(1)).getStringValue());
                IACursor cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(2)).getCursor();
                ArrayList<List<String>> partitioningKey = new ArrayList<List<String>>();
                while (cursor.next()) {
                    AOrderedList fieldNameList = (AOrderedList)cursor.get();
                    IACursor nestedFieldNameCursor = fieldNameList.getCursor();
                    ArrayList<String> nestedFieldName = new ArrayList<String>();
                    while (nestedFieldNameCursor.next()) {
                        nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
                    }
                    partitioningKey.add(nestedFieldName);
                }
                ArrayList<IAType> primaryKeyTypes = null;
                int primaryKeyTypesPos = datasetDetailsRecord.getType().getFieldIndex("PrimaryKeyTypes");
                if (primaryKeyTypesPos >= 0) {
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(primaryKeyTypesPos)).getCursor();
                    primaryKeyTypes = new ArrayList<IAType>();
                    while (cursor.next()) {
                        String primaryKeyTypeName = ((AString)cursor.get()).getStringValue();
                        BuiltinType primaryKeyType = BuiltinTypeMap.getBuiltinType((String)primaryKeyTypeName);
                        primaryKeyTypes.add((IAType)primaryKeyType);
                    }
                }
                boolean autogenerated = ((ABoolean)datasetDetailsRecord.getValueByPos(4)).getBoolean();
                Integer filterSourceIndicator = null;
                int filterSourceIndicatorPos = datasetDetailsRecord.getType().getFieldIndex("FilterSourceIndicator");
                if (filterSourceIndicatorPos >= 0) {
                    filterSourceIndicator = ((AInt8)datasetDetailsRecord.getValueByPos(filterSourceIndicatorPos)).getByteValue();
                }
                ArrayList<String> filterField = null;
                int filterFieldPos = datasetDetailsRecord.getType().getFieldIndex("FilterField");
                if (filterFieldPos >= 0) {
                    if (filterSourceIndicator == null) {
                        filterSourceIndicator = 0;
                    }
                    filterField = new ArrayList<String>();
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(filterFieldPos)).getCursor();
                    while (cursor.next()) {
                        filterField.add(((AString)cursor.get()).getStringValue());
                    }
                }
                ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>();
                int keyFieldSourceIndicatorIndex = datasetDetailsRecord.getType().getFieldIndex("KeySourceIndicator");
                if (keyFieldSourceIndicatorIndex >= 0) {
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
                    while (cursor.next()) {
                        keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
                    }
                } else {
                    for (int index = 0; index < partitioningKey.size(); ++index) {
                        keyFieldSourceIndicator.add(0);
                    }
                }
                boolean isDatasetWithoutTypeSpec = primaryKeyTypes != null && !primaryKeyTypes.isEmpty();
                datasetDetails = new InternalDatasetDetails(fileStructure, partitioningStrategy, partitioningKey, partitioningKey, keyFieldSourceIndicator, primaryKeyTypes, autogenerated, filterSourceIndicator, filterField, isDatasetWithoutTypeSpec);
                break;
            }
            case EXTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(this.datasetEntity.externalDetailsIndex());
                String adapter = ((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue();
                IACursor cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(1)).getCursor();
                HashMap<String, String> properties = new HashMap<String, String>();
                while (cursor.next()) {
                    ARecord field = (ARecord)cursor.get();
                    String key = ((AString)field.getValueByPos(0)).getStringValue();
                    String value = ((AString)field.getValueByPos(1)).getStringValue();
                    properties.put(key, value);
                }
                Date timestamp = new Date(((ADateTime)datasetDetailsRecord.getValueByPos(2)).getChrononTime());
                DatasetConfig.TransactionState state = DatasetConfig.TransactionState.values()[((AInt32)datasetDetailsRecord.getValueByPos(3)).getIntegerValue()];
                datasetDetails = new ExternalDatasetDetails(adapter, properties, timestamp, state);
                break;
            }
            case VIEW: {
                int datasetDetailsFieldPos = recType.getFieldIndex("ViewDetails");
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(datasetDetailsFieldPos);
                int definitionFieldPos = datasetDetailsRecord.getType().getFieldIndex("Definition");
                String definition = ((AString)datasetDetailsRecord.getValueByPos(definitionFieldPos)).getStringValue();
                List<List<DependencyFullyQualifiedName>> dependencies = Collections.emptyList();
                int dependenciesFieldPos = datasetDetailsRecord.getType().getFieldIndex("Dependencies");
                if (dependenciesFieldPos >= 0) {
                    dependencies = new ArrayList();
                    IACursor dependenciesCursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(dependenciesFieldPos)).getCursor();
                    while (dependenciesCursor.next()) {
                        ArrayList<DependencyFullyQualifiedName> dependencyList = new ArrayList<DependencyFullyQualifiedName>();
                        IACursor qualifiedDependencyCursor = ((AOrderedList)dependenciesCursor.get()).getCursor();
                        while (qualifiedDependencyCursor.next()) {
                            DependencyFullyQualifiedName dependency = DatasetTupleTranslator.getDependency((AOrderedList)qualifiedDependencyCursor.get());
                            dependencyList.add(dependency);
                        }
                        dependencies.add(dependencyList);
                    }
                }
                Boolean defaultNull = null;
                int defaultFieldPos = datasetDetailsRecord.getType().getFieldIndex("Default");
                if (defaultFieldPos >= 0) {
                    IAObject defaultValue = datasetDetailsRecord.getValueByPos(defaultFieldPos);
                    defaultNull = defaultValue.getType().getTypeTag() == ATypeTag.NULL;
                }
                ArrayList<String> primaryKeyFields = null;
                int primaryKeyFieldPos = datasetDetailsRecord.getType().getFieldIndex("PrimaryKey");
                if (primaryKeyFieldPos >= 0) {
                    AOrderedList primaryKeyFieldList = (AOrderedList)datasetDetailsRecord.getValueByPos(primaryKeyFieldPos);
                    int n = primaryKeyFieldList.size();
                    primaryKeyFields = new ArrayList<String>(n);
                    for (int i = 0; i < n; ++i) {
                        AOrderedList list = (AOrderedList)primaryKeyFieldList.getItem(i);
                        if (list.size() != 1) {
                            throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{list.toJSON()});
                        }
                        AString str = (AString)list.getItem(0);
                        primaryKeyFields.add(str.getStringValue());
                    }
                }
                ArrayList<ViewDetails.ForeignKey> foreignKeys = null;
                int foreignKeysFieldPos = datasetDetailsRecord.getType().getFieldIndex("ForeignKeys");
                if (foreignKeysFieldPos >= 0) {
                    AOrderedList foreignKeyRecordsList = (AOrderedList)datasetDetailsRecord.getValueByPos(foreignKeysFieldPos);
                    int nForeignKeys = foreignKeyRecordsList.size();
                    foreignKeys = new ArrayList<ViewDetails.ForeignKey>(nForeignKeys);
                    for (int i = 0; i < nForeignKeys; ++i) {
                        ARecord foreignKeyRecord = (ARecord)foreignKeyRecordsList.getItem(i);
                        int foreignKeyFieldPos = foreignKeyRecord.getType().getFieldIndex("ForeignKey");
                        AOrderedList foreignKeyFieldList = (AOrderedList)foreignKeyRecord.getValueByPos(foreignKeyFieldPos);
                        int nForeignKeyFields = foreignKeyFieldList.size();
                        ArrayList<String> foreignKeyFields = new ArrayList<String>(nForeignKeyFields);
                        for (int j = 0; j < nForeignKeyFields; ++j) {
                            AOrderedList list = (AOrderedList)foreignKeyFieldList.getItem(j);
                            if (list.size() != 1) {
                                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{list.toJSON()});
                            }
                            AString str = (AString)list.getItem(0);
                            foreignKeyFields.add(str.getStringValue());
                        }
                        int refDataverseNameFieldPos = foreignKeyRecord.getType().getFieldIndex("RefDataverseName");
                        String refDataverseCanonicalName = ((AString)foreignKeyRecord.getValueByPos(refDataverseNameFieldPos)).getStringValue();
                        DataverseName refDataverseName = DataverseName.createFromCanonicalForm((String)refDataverseCanonicalName);
                        int refDatabaseNameFieldPos = foreignKeyRecord.getType().getFieldIndex("RefDatabaseName");
                        String refDatabase = refDatabaseNameFieldPos >= 0 ? ((AString)foreignKeyRecord.getValueByPos(refDatabaseNameFieldPos)).getStringValue() : MetadataUtil.databaseFor((DataverseName)refDataverseName);
                        int refDatasetNameFieldPos = foreignKeyRecord.getType().getFieldIndex("RefDatasetName");
                        String refDatasetName = ((AString)foreignKeyRecord.getValueByPos(refDatasetNameFieldPos)).getStringValue();
                        foreignKeys.add(new ViewDetails.ForeignKey(foreignKeyFields, new DatasetFullyQualifiedName(refDatabase, refDataverseName, refDatasetName)));
                    }
                }
                Triple<String, String, String> dateTimeFormats = DatasetTupleTranslator.getDateTimeFormats(datasetDetailsRecord);
                String datetimeFormat = (String)dateTimeFormats.first;
                String dateFormat = (String)dateTimeFormats.second;
                String timeFormat = (String)dateTimeFormats.third;
                datasetDetails = new ViewDetails(definition, dependencies, defaultNull, primaryKeyFields, foreignKeys, datetimeFormat, dateFormat, timeFormat);
                break;
            }
        }
        Map<String, String> hints = this.getDatasetHints(datasetRecord);
        String metaItemTypeDatabaseName = null;
        DataverseName metaTypeDataverseName = null;
        String metaTypeName = null;
        int metaTypeDataverseNameIndex = recType.getFieldIndex("MetatypeDataverseName");
        if (metaTypeDataverseNameIndex >= 0) {
            String metaTypeDataverseCanonicalName = ((AString)datasetRecord.getValueByPos(metaTypeDataverseNameIndex)).getStringValue();
            metaTypeDataverseName = DataverseName.createFromCanonicalForm((String)metaTypeDataverseCanonicalName);
            int metaTypeNameIndex = recType.getFieldIndex("MetatypeName");
            metaTypeName = ((AString)datasetRecord.getValueByPos(metaTypeNameIndex)).getStringValue();
            int metaTypeDatabaseIdx = recType.getFieldIndex("MetatypeDatabaseName");
            metaItemTypeDatabaseName = metaTypeDatabaseIdx >= 0 ? ((AString)datasetRecord.getValueByPos(metaTypeDatabaseIdx)).getStringValue() : MetadataUtil.databaseFor((DataverseName)metaTypeDataverseName);
        }
        long rebalanceCount = this.getRebalanceCount(datasetRecord);
        String compressionScheme = this.getCompressionScheme(datasetRecord);
        DatasetFormatInfo datasetFormatInfo = this.getDatasetFormatInfo(datasetRecord);
        return new Dataset(databaseName, dataverseName, datasetName, itemTypeDatabaseName, typeDataverseName, typeName, metaItemTypeDatabaseName, metaTypeDataverseName, metaTypeName, nodeGroupName, (String)compactionPolicy.first, (Map)compactionPolicy.second, datasetDetails, hints, datasetType, datasetId, pendingOp, rebalanceCount, compressionScheme, datasetFormatInfo);
    }

    protected Pair<String, Map<String, String>> readCompactionPolicy(DatasetConfig.DatasetType datasetType, ARecord datasetRecord) {
        Map<String, String> compactionPolicyProperties;
        String compactionPolicy = ((AString)datasetRecord.getValueByPos(this.datasetEntity.compactionPolicyIndex())).getStringValue();
        AOrderedList compactionPolicyPropertiesList = (AOrderedList)datasetRecord.getValueByPos(this.datasetEntity.compactionPolicyPropertiesIndex());
        if (compactionPolicyPropertiesList.size() > 0) {
            compactionPolicyProperties = new LinkedHashMap();
            IACursor cursor = compactionPolicyPropertiesList.getCursor();
            while (cursor.next()) {
                ARecord field = (ARecord)cursor.get();
                String key = ((AString)field.getValueByPos(0)).getStringValue();
                String value = ((AString)field.getValueByPos(1)).getStringValue();
                compactionPolicyProperties.put(key, value);
            }
        } else {
            compactionPolicyProperties = Collections.emptyMap();
        }
        return new Pair((Object)compactionPolicy, compactionPolicyProperties);
    }

    private long getRebalanceCount(ARecord datasetRecord) {
        int rebalanceCountIndex = datasetRecord.getType().getFieldIndex("rebalanceCount");
        return rebalanceCountIndex >= 0 ? ((AInt64)datasetRecord.getValueByPos(rebalanceCountIndex)).getLongValue() : 0L;
    }

    private String getCompressionScheme(ARecord datasetRecord) {
        ARecordType datasetType = datasetRecord.getType();
        int compressionIndex = datasetType.getFieldIndex("BlockLevelStorageCompression");
        if (compressionIndex >= 0) {
            ARecordType compressionType = (ARecordType)datasetType.getFieldTypes()[compressionIndex];
            int schemeIndex = compressionType.getFieldIndex("DatasetCompressionScheme");
            ARecord compressionRecord = (ARecord)datasetRecord.getValueByPos(compressionIndex);
            return ((AString)compressionRecord.getValueByPos(schemeIndex)).getStringValue();
        }
        return "none";
    }

    private DatasetFormatInfo getDatasetFormatInfo(ARecord datasetRecord) {
        int formatIndex;
        ARecordType datasetType = datasetRecord.getType();
        int datasetFormatIndex = datasetType.getFieldIndex("DatasetFormat");
        if (datasetFormatIndex < 0) {
            return DatasetFormatInfo.SYSTEM_DEFAULT;
        }
        ARecordType datasetFormatType = (ARecordType)datasetType.getFieldTypes()[datasetFormatIndex];
        ARecord datasetFormatRecord = (ARecord)datasetRecord.getValueByPos(datasetFormatIndex);
        AString formatString = (AString)datasetFormatRecord.getValueByPos(formatIndex = datasetFormatType.getFieldIndex("Format"));
        DatasetConfig.DatasetFormat format = DatasetConfig.DatasetFormat.valueOf((String)formatString.getStringValue());
        if (format == DatasetConfig.DatasetFormat.ROW) {
            return DatasetFormatInfo.SYSTEM_DEFAULT;
        }
        int maxTupleCountIndex = datasetFormatType.getFieldIndex("MaxTupleCount");
        AInt64 maxTupleCountInt = (AInt64)datasetFormatRecord.getValueByPos(maxTupleCountIndex);
        int maxTupleCount = (int)maxTupleCountInt.getLongValue();
        int freeSpaceToleranceIndex = datasetFormatType.getFieldIndex("FreeSpaceTolerance");
        ADouble freeSpaceToleranceDouble = (ADouble)datasetFormatRecord.getValueByPos(freeSpaceToleranceIndex);
        double freeSpaceTolerance = freeSpaceToleranceDouble.getDoubleValue();
        int maxLeafNodeSizeIndex = datasetFormatType.getFieldIndex("MaxLeafNodeSize");
        AInt64 maxLeafNodeSizeInt = (AInt64)datasetFormatRecord.getValueByPos(maxLeafNodeSizeIndex);
        int maxLeafNodeSize = (int)maxLeafNodeSizeInt.getLongValue();
        return new DatasetFormatInfo(format, maxTupleCount, freeSpaceTolerance, maxLeafNodeSize);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Dataset dataset) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        String databaseName = dataset.getDatabaseName();
        String dataverseCanonicalName = dataset.getDataverseName().getCanonicalForm();
        String datasetName = dataset.getDatasetName();
        this.tupleBuilder.reset();
        if (this.datasetEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(databaseName);
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(datasetName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.datasetEntity.getRecordType());
        if (this.datasetEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(databaseName);
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.datasetEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(datasetName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.datasetNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.datatypeDataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.datatypeNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDatasetType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.datasetTypeIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getNodeGroupName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.groupNameIndex(), (IValueReference)this.fieldValue);
        this.writeCompactionPolicy(dataset.getDatasetType(), dataset.getCompactionPolicy(), dataset.getCompactionPolicyProperties(), listBuilder, itemValue);
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                this.fieldValue.reset();
                dataset.getDatasetDetails().writeDatasetDetailsRecordType(this.fieldValue.getDataOutput(), this.datasetEntity);
                this.recordBuilder.addField(this.datasetEntity.internalDetailsIndex(), (IValueReference)this.fieldValue);
                break;
            }
            case EXTERNAL: {
                this.fieldValue.reset();
                dataset.getDatasetDetails().writeDatasetDetailsRecordType(this.fieldValue.getDataOutput(), this.datasetEntity);
                this.recordBuilder.addField(this.datasetEntity.externalDetailsIndex(), (IValueReference)this.fieldValue);
            }
        }
        UnorderedListBuilder uListBuilder = new UnorderedListBuilder();
        uListBuilder.reset((AbstractCollectionType)((AUnorderedListType)this.datasetEntity.getRecordType().getFieldTypes()[this.datasetEntity.hintsIndex()]));
        for (Map.Entry<String, String> property : dataset.getHints().entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            itemValue.reset();
            this.writeDatasetHintRecord(name, value, itemValue.getDataOutput());
            uListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        uListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.datasetEntity.hintsIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getDatasetId());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.datasetIdIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getPendingOp());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.pendingOpIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(dataset);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeCompactionPolicy(DatasetConfig.DatasetType datasetType, String compactionPolicy, Map<String, String> compactionPolicyProperties, OrderedListBuilder listBuilder, ArrayBackedValueStorage itemValue) throws HyracksDataException {
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.datasetEntity.compactionPolicyIndex(), (IValueReference)this.fieldValue);
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)this.datasetEntity.getRecordType().getFieldTypes()[this.datasetEntity.compactionPolicyPropertiesIndex()]));
        if (compactionPolicyProperties != null && !compactionPolicyProperties.isEmpty()) {
            for (Map.Entry<String, String> property : compactionPolicyProperties.entrySet()) {
                String name = property.getKey();
                String value = property.getValue();
                itemValue.reset();
                DatasetUtil.writePropertyTypeRecord(name, value, itemValue.getDataOutput(), MetadataRecordTypes.COMPACTION_POLICY_PROPERTIES_RECORDTYPE);
                listBuilder.addItem((IValueReference)itemValue);
            }
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(this.datasetEntity.compactionPolicyPropertiesIndex(), (IValueReference)this.fieldValue);
    }

    protected void writeOpenFields(Dataset dataset) throws HyracksDataException {
        this.writeItemTypeDatabase(dataset);
        this.writeMetaPart(dataset);
        this.writeRebalanceCount(dataset);
        this.writeBlockLevelStorageCompression(dataset);
        this.writeOpenDetails(dataset);
        this.writeDatasetFormatInfo(dataset);
    }

    private void writeOpenDetails(Dataset dataset) throws HyracksDataException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.VIEW) {
            this.fieldName.reset();
            this.aString.setValue("ViewDetails");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            dataset.getDatasetDetails().writeDatasetDetailsRecordType(this.fieldValue.getDataOutput(), this.datasetEntity);
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeItemTypeDatabase(Dataset dataset) throws HyracksDataException {
        if (this.datasetEntity.databaseNameIndex() >= 0) {
            this.fieldName.reset();
            this.aString.setValue("DatatypeDatabaseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getItemTypeDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeMetaPart(Dataset dataset) throws HyracksDataException {
        if (dataset.hasMetaPart()) {
            if (this.datasetEntity.databaseNameIndex() >= 0) {
                this.fieldName.reset();
                this.aString.setValue("MetatypeDatabaseName");
                this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
                this.fieldValue.reset();
                this.aString.setValue(dataset.getMetaItemTypeDatabaseName());
                this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
                this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            }
            this.fieldName.reset();
            this.aString.setValue("MetatypeDataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeDataverseName().getCanonicalForm());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            this.fieldName.reset();
            this.aString.setValue("MetatypeName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    private void writeBlockLevelStorageCompression(Dataset dataset) throws HyracksDataException {
        if ("none".equals(dataset.getCompressionScheme())) {
            return;
        }
        RecordBuilder compressionObject = new RecordBuilder();
        compressionObject.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("DatasetCompressionScheme");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(dataset.getCompressionScheme());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        compressionObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        this.fieldName.reset();
        this.aString.setValue("BlockLevelStorageCompression");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        compressionObject.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeDatasetFormatInfo(Dataset dataset) throws HyracksDataException {
        DatasetFormatInfo info = dataset.getDatasetFormatInfo();
        RecordBuilder datasetFormatObject = new RecordBuilder();
        datasetFormatObject.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.fieldName.reset();
        this.aString.setValue("Format");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(info.getFormat().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        datasetFormatObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        if (info.getFormat() == DatasetConfig.DatasetFormat.COLUMN) {
            this.fieldName.reset();
            this.aString.setValue("MaxTupleCount");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aInt64.setValue((long)info.getMaxTupleCount());
            this.int64Serde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
            datasetFormatObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            this.fieldName.reset();
            this.aString.setValue("FreeSpaceTolerance");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aDouble.setValue(info.getFreeSpaceTolerance());
            this.doubleSerde.serialize((Object)this.aDouble, this.fieldValue.getDataOutput());
            datasetFormatObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            this.fieldName.reset();
            this.aString.setValue("MaxLeafNodeSize");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aInt64.setValue((long)info.getMaxLeafNodeSize());
            this.int64Serde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
            datasetFormatObject.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
        this.fieldName.reset();
        this.aString.setValue("DatasetFormat");
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        datasetFormatObject.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeRebalanceCount(Dataset dataset) throws HyracksDataException {
        if (dataset.getRebalanceCount() > 0L) {
            this.fieldName.reset();
            this.aString.setValue("rebalanceCount");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aInt64.setValue(dataset.getRebalanceCount());
            this.int64Serde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    protected Map<String, String> getDatasetHints(ARecord datasetRecord) {
        HashMap<String, String> hints = new HashMap<String, String>();
        AUnorderedList list = (AUnorderedList)datasetRecord.getValueByPos(this.datasetEntity.hintsIndex());
        IACursor cursor = list.getCursor();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            hints.put(key, value);
        }
        return hints;
    }

    protected void writeDatasetHintRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.DATASET_HINTS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        fieldValue.reset();
        aString.setValue(name);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

