/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.metadata.lock.DatasetLock;
import org.apache.asterix.metadata.lock.MetadataLock;
import org.apache.asterix.metadata.lock.MetadataLockKey;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockManager
implements IMetadataLockManager {
    private static final Function<MetadataLockKey, MetadataLock> LOCK_FUNCTION = MetadataLock::new;
    private static final Function<MetadataLockKey, DatasetLock> DATASET_LOCK_FUNCTION = DatasetLock::new;
    private final ConcurrentMap<MetadataLockKey, IMetadataLock> mdlocks = new ConcurrentHashMap<MetadataLockKey, IMetadataLock>();

    public void acquireDatabaseReadLock(LockList locks, String database) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatabaseLockKey(database);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDatabaseWriteLock(LockList locks, String database) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatabaseLockKey(database);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDataverseReadLock(LockList locks, String database, DataverseName dataverseName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataverseLockKey(database, dataverseName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataverseWriteLock(LockList locks, String database, DataverseName dataverseName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataverseLockKey(database, dataverseName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDatasetReadLock(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, (IMetadataLock)lock);
    }

    public void acquireDatasetWriteLock(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, (IMetadataLock)lock);
    }

    public void acquireDatasetModifyLock(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.MODIFY, (IMetadataLock)lock);
    }

    public void acquireDatasetCreateIndexLock(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.INDEX_BUILD, (IMetadataLock)lock);
    }

    public void acquireDatasetExclusiveModificationLock(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }

    public void acquireFunctionReadLock(LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFunctionLockKey(database, dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFunctionWriteLock(LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFunctionLockKey(database, dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFullTextConfigReadLock(LockList locks, String database, DataverseName dataverseName, String fullTextConfigName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFullTextConfigLockKey(database, dataverseName, fullTextConfigName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFullTextConfigWriteLock(LockList locks, String database, DataverseName dataverseName, String fullTextConfigName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFullTextConfigLockKey(database, dataverseName, fullTextConfigName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFullTextFilterReadLock(LockList locks, String database, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFullTextFilterLockKey(database, dataverseName, fullTextFilterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFullTextFilterWriteLock(LockList locks, String database, DataverseName dataverseName, String fullTextFilterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFullTextFilterLockKey(database, dataverseName, fullTextFilterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireLibraryReadLock(LockList locks, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createLibraryLockKey(database, dataverseName, libraryName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireLibraryWriteLock(LockList locks, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createLibraryLockKey(database, dataverseName, libraryName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireAdapterReadLock(LockList locks, String database, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createAdapterLockKey(database, dataverseName, adapterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireAdapterWriteLock(LockList locks, String database, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createAdapterLockKey(database, dataverseName, adapterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireNodeGroupReadLock(LockList locks, String nodeGroupName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createNodeGroupLockKey(nodeGroupName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireNodeGroupWriteLock(LockList locks, String nodeGroupName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createNodeGroupLockKey(nodeGroupName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireActiveEntityReadLock(LockList locks, String database, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createActiveEntityLockKey(database, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireActiveEntityWriteLock(LockList locks, String database, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createActiveEntityLockKey(database, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyWriteLock(LockList locks, String database, DataverseName dataverseName, String feedPolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFeedPolicyLockKey(database, dataverseName, feedPolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyReadLock(LockList locks, String database, DataverseName dataverseName, String feedPolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFeedPolicyLockKey(database, dataverseName, feedPolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyReadLock(LockList locks, String mergePolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createMergePolicyLockKey(mergePolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyWriteLock(LockList locks, String mergePolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createMergePolicyLockKey(mergePolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDataTypeReadLock(LockList locks, String database, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataTypeLockKey(database, dataverseName, datatypeName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataTypeWriteLock(LockList locks, String database, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataTypeLockKey(database, dataverseName, datatypeName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireSynonymReadLock(LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createSynonymLockKey(database, dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireSynonymWriteLock(LockList locks, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createSynonymLockKey(database, dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireExtensionEntityReadLock(LockList locks, String extension, String database, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createExtensionEntityLockKey(extension, database, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireExtensionEntityWriteLock(LockList locks, String extension, String database, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createExtensionEntityLockKey(extension, database, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void upgradeDatasetLockToWrite(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.upgrade(IMetadataLock.Mode.UPGRADED_WRITE, (IMetadataLock)lock);
    }

    public void downgradeDatasetLockToExclusiveModify(LockList locks, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(database, dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.downgrade(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }
}

