/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryCorrelatedTreeIndexOperationsHelper;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.operators.LSMSecondaryIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;

public class SecondaryCorrelatedBTreeOperationsHelper
extends SecondaryCorrelatedTreeIndexOperationsHelper {
    protected SecondaryCorrelatedBTreeOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        super(dataset, index, metadataProvider, sourceLoc);
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)this.index.getIndexDetails();
        boolean excludeUnknown = SecondaryCorrelatedBTreeOperationsHelper.excludeUnknownKeys(this.index, indexDetails, this.anySecondaryKeyIsNullable);
        assert (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL);
        IndexUtil.bindJobEventListener(spec, this.metadataProvider);
        IOperatorDescriptor keyProviderOp = DatasetUtil.createCorrelatedDummyKeyProviderOp(spec, this.primaryPartitionConstraint);
        IOperatorDescriptor primaryScanOp = this.createPrimaryIndexScanDiskComponentsOp(spec, this.metadataProvider, this.getTaggedRecordDescriptor(this.dataset.getPrimaryRecordDescriptor(this.metadataProvider)));
        RecordDescriptor taggedSecondaryRecDesc = this.getTaggedRecordDescriptor(this.secondaryRecDesc);
        AlgebricksMetaOperatorDescriptor asterixAssignOp = this.createAssignOp(spec, indexDetails.getKeyFieldNames().size(), taggedSecondaryRecDesc);
        IOperatorDescriptor processorOp = this.createTupleProcessorOp(spec, taggedSecondaryRecDesc, this.getNumSecondaryKeys(), this.numPrimaryKeys, false, excludeUnknown, false);
        ExternalSortOperatorDescriptor sortOp = this.createSortOp(spec, this.getTaggedSecondaryComparatorFactories(this.secondaryComparatorFactories), taggedSecondaryRecDesc);
        LSMSecondaryIndexBulkLoadOperatorDescriptor secondaryBulkLoadOp = this.createTreeIndexBulkLoadOp(spec, this.metadataProvider, taggedSecondaryRecDesc, this.createFieldPermutationForBulkLoadOp(), this.getNumSecondaryKeys(), this.numPrimaryKeys, false);
        SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
        sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor metaOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[]{taggedSecondaryRecDesc});
        metaOp.setSourceLocation(this.sourceLoc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), keyProviderOp, 0, primaryScanOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), primaryScanOp, 0, (IOperatorDescriptor)asterixAssignOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)asterixAssignOp, 0, processorOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), processorOp, 0, (IOperatorDescriptor)sortOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)sortOp, 0, (IOperatorDescriptor)secondaryBulkLoadOp, 0);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), (IOperatorDescriptor)secondaryBulkLoadOp, 0, (IOperatorDescriptor)metaOp, 0);
        spec.addRoot((IOperatorDescriptor)metaOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    protected int getNumSecondaryKeys() {
        return ((Index.ValueIndexDetails)this.index.getIndexDetails()).getKeyFieldNames().size();
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        ARecordType enforcedType;
        int sourceColumn;
        ARecordType sourceType;
        int i;
        Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)this.index.getIndexDetails();
        int numSecondaryKeys = this.getNumSecondaryKeys();
        this.secondaryFieldAccessEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeys + this.numFilterFields];
        this.secondaryComparatorFactories = new IBinaryComparatorFactory[numSecondaryKeys + this.numPrimaryKeys];
        this.secondaryBloomFilterKeyFields = new int[numSecondaryKeys];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[numSecondaryKeys + this.numPrimaryKeys + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[numSecondaryKeys + this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = this.metadataProvider.getDataFormat().getSerdeProvider();
        ITypeTraitProvider typeTraitProvider = this.metadataProvider.getDataFormat().getTypeTraitProvider();
        IBinaryComparatorFactoryProvider comparatorFactoryProvider = this.metadataProvider.getDataFormat().getBinaryComparatorFactoryProvider();
        int recordColumn = 2 + this.numPrimaryKeys;
        boolean isOverridingKeyTypes = indexDetails.isOverridingKeyFieldTypes();
        for (i = 0; i < numSecondaryKeys; ++i) {
            List<Integer> keySourceIndicators = indexDetails.getKeyFieldSourceIndicators();
            if (keySourceIndicators == null || keySourceIndicators.get(i) == 0) {
                sourceType = this.itemType;
                sourceColumn = recordColumn;
                enforcedType = this.enforcedItemType;
            } else {
                sourceType = this.metaType;
                sourceColumn = recordColumn + 1;
                enforcedType = this.enforcedMetaType;
            }
            List<String> secFieldName = indexDetails.getKeyFieldNames().get(i);
            IAType secFieldType = indexDetails.getKeyFieldTypes().get(i);
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(this.index, secFieldType, secFieldName, sourceType);
            IAType keyType = (IAType)keyTypePair.first;
            IScalarEvaluatorFactory secFieldAccessor = this.createFieldAccessor(sourceType, sourceColumn, secFieldName);
            this.secondaryFieldAccessEvalFactories[i] = this.createFieldCast(secFieldAccessor, isOverridingKeyTypes, (IAType)enforcedType, sourceType, keyType);
            this.anySecondaryKeyIsNullable = this.anySecondaryKeyIsNullable || (Boolean)keyTypePair.second != false;
            secondaryRecFields[i] = serdeProvider.getSerializerDeserializer((Object)keyType);
            this.secondaryComparatorFactories[i] = comparatorFactoryProvider.getBinaryComparatorFactory((Object)keyType, true);
            this.secondaryTypeTraits[i] = typeTraitProvider.getTypeTrait((Object)keyType);
            this.secondaryBloomFilterKeyFields[i] = i;
        }
        for (i = 0; i < this.numPrimaryKeys; ++i) {
            secondaryRecFields[numSecondaryKeys + i] = this.primaryRecDesc.getFields()[i];
            enforcedRecFields[i] = this.primaryRecDesc.getFields()[i];
            this.secondaryTypeTraits[numSecondaryKeys + i] = this.primaryRecDesc.getTypeTraits()[i];
            enforcedTypeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
            this.secondaryComparatorFactories[numSecondaryKeys + i] = this.primaryComparatorFactories[i];
        }
        enforcedRecFields[this.numPrimaryKeys] = serdeProvider.getSerializerDeserializer((Object)this.itemType);
        enforcedTypeTraits[this.numPrimaryKeys] = typeTraitProvider.getTypeTrait((Object)this.itemType);
        if (this.dataset.hasMetaPart()) {
            enforcedRecFields[this.numPrimaryKeys + 1] = serdeProvider.getSerializerDeserializer((Object)this.metaType);
            enforcedTypeTraits[this.numPrimaryKeys + 1] = typeTraitProvider.getTypeTrait((Object)this.metaType);
        }
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            Integer filterSourceIndicator = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getFilterSourceIndicator();
            if (filterSourceIndicator == null || filterSourceIndicator == 0) {
                sourceType = this.itemType;
                sourceColumn = recordColumn;
                enforcedType = this.enforcedItemType;
            } else {
                sourceType = this.metaType;
                sourceColumn = recordColumn + 1;
                enforcedType = this.enforcedMetaType;
            }
            IAType filterType = (IAType)Index.getNonNullableKeyFieldType((List<String>)this.filterFieldName, (ARecordType)sourceType).first;
            IScalarEvaluatorFactory filterAccessor = this.createFieldAccessor(sourceType, sourceColumn, this.filterFieldName);
            this.secondaryFieldAccessEvalFactories[numSecondaryKeys] = this.createFieldCast(filterAccessor, isOverridingKeyTypes, (IAType)enforcedType, sourceType, filterType);
            secondaryRecFields[this.numPrimaryKeys + numSecondaryKeys] = serde = serdeProvider.getSerializerDeserializer((Object)filterType);
            enforcedRecFields[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = serde;
            enforcedTypeTraits[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = typeTraitProvider.getTypeTrait((Object)filterType);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields, this.secondaryTypeTraits);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
    }
}

