/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.jdbc.core.ADBConnection;
import org.apache.asterix.jdbc.core.ADBDriverContext;
import org.apache.asterix.jdbc.core.ADBDriverProperty;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBProductVersion;
import org.apache.asterix.jdbc.core.ADBProtocolBase;

public abstract class ADBDriverBase {
    static final int JDBC_MAJOR_VERSION = 4;
    static final int JDBC_MINOR_VERSION = 2;
    static final String JDBC_SCHEME = "jdbc:";
    static final String LOGGING_PROPERTY_SUFFIX = ".log.stderr";
    protected final String urlScheme;
    protected final int defaultApiPort;
    protected final ADBErrorReporter errorReporter;
    private volatile ADBProductVersion driverVersion;
    private volatile Map<String, ADBDriverProperty> supportedPropertiesIndex;
    private volatile ADBDriverContext context;

    public ADBDriverBase(String driverScheme, int defaultApiPort) {
        this.urlScheme = JDBC_SCHEME + Objects.requireNonNull(driverScheme);
        this.defaultApiPort = defaultApiPort;
        this.errorReporter = this.createErrorReporter();
    }

    protected static void registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            DriverManager.println(String.format("Error registering driver %s. %s", driver.getClass().getName(), e));
        }
    }

    protected void parseConnectionProperties(Properties inProps, Map<ADBDriverProperty, Object> outProperties, Map<String, ADBDriverProperty> supportedProperties, SQLWarning outWarning) throws SQLException {
        if (inProps != null) {
            Enumeration<?> en = inProps.propertyNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement().toString();
                String value = inProps.getProperty(name);
                this.parseConnectionProperty(name, value, supportedProperties, outProperties, outWarning);
            }
        }
    }

    protected void parseConnectionProperty(String name, String textValue, Map<String, ADBDriverProperty> supportedProperties, Map<ADBDriverProperty, Object> outProperties, SQLWarning outWarning) throws SQLException {
        Object value;
        ADBDriverProperty property = supportedProperties.get(name);
        if (property == null) {
            outWarning.setNextWarning(new SQLWarning(this.errorReporter.warningParameterNotSupported(name)));
            return;
        }
        if (textValue == null || textValue.isEmpty()) {
            return;
        }
        try {
            value = Objects.requireNonNull(property.getValueParser().apply(textValue));
        }
        catch (RuntimeException e) {
            throw this.errorReporter.errorParameterValueNotSupported(name);
        }
        outProperties.put(property, value);
    }

    private static Logger getParentLogger(Class<?> driverClass) {
        return Logger.getLogger(driverClass.getPackage().getName());
    }

    protected static void setupLogging(Class<? extends Driver> driverClass) {
        Level level;
        String logLevel = System.getProperty(driverClass.getPackage().getName() + LOGGING_PROPERTY_SUFFIX);
        if (logLevel == null) {
            return;
        }
        try {
            level = Boolean.TRUE.toString().equals(logLevel) ? Level.ALL : Level.parse(logLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(level);
        Logger parentLogger = ADBDriverBase.getParentLogger(driverClass);
        parentLogger.setLevel(level);
        parentLogger.addHandler(ch);
    }

    public boolean acceptsURL(String url) {
        return url.startsWith(this.urlScheme);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        URI subUri;
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            subUri = new URI(url.substring(JDBC_SCHEME.length()));
        }
        catch (URISyntaxException e) {
            throw this.errorReporter.errorParameterValueNotSupported("URL");
        }
        String host = subUri.getHost();
        if (host == null) {
            throw this.errorReporter.errorParameterValueNotSupported("URL");
        }
        int port = subUri.getPort();
        if (port <= 0) {
            port = this.defaultApiPort;
        }
        HashMap<ADBDriverProperty, Object> properties = new HashMap<ADBDriverProperty, Object>();
        Map<String, ADBDriverProperty> supportedProperties = this.getOrCreateSupportedPropertiesIndex();
        SQLWarning warning = new SQLWarning();
        this.parseConnectionProperties(this.getURIParameters(subUri), properties, supportedProperties, warning);
        this.parseConnectionProperties(info, properties, supportedProperties, warning);
        warning = warning.getNextWarning() != null ? warning.getNextWarning() : null;
        this.checkDriverVersion(properties);
        String dataverseCanonicalName = this.getDataverseCanonicalNameFromURI(subUri);
        ADBDriverContext driverContext = this.getOrCreateDriverContext();
        ADBProtocolBase protocol = this.createProtocol(host, port, properties, driverContext);
        try {
            String serverVersion = protocol.connect();
            ADBProductVersion databaseVersion = protocol.parseDatabaseVersion(serverVersion);
            this.checkDatabaseVersion(properties, databaseVersion);
            return this.createConnection(protocol, url, databaseVersion, dataverseCanonicalName, properties, warning);
        }
        catch (SQLException e) {
            try {
                protocol.close();
            }
            catch (SQLException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    protected String getDataverseCanonicalNameFromURI(URI subUri) {
        String path = subUri.getPath();
        return path != null && path.length() > 1 && path.startsWith("/") ? path.substring(1) : null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Collection<ADBDriverProperty> supportedProperties = this.getOrCreateSupportedPropertiesIndex().values();
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>(supportedProperties.size());
        for (ADBDriverProperty property : supportedProperties) {
            if (property.isHidden()) continue;
            Object defaultValue = property.getDefaultValue();
            DriverPropertyInfo propInfo = new DriverPropertyInfo(property.getPropertyName(), defaultValue != null ? defaultValue.toString() : null);
            result.add(propInfo);
        }
        return result.toArray(new DriverPropertyInfo[0]);
    }

    public int getMajorVersion() {
        return this.getOrCreateDriverVersion().getMajorVersion();
    }

    public int getMinorVersion() {
        return this.getOrCreateDriverVersion().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public Logger getParentLogger() {
        return ADBDriverBase.getParentLogger(this.getClass());
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ADBDriverContext getOrCreateDriverContext() {
        ADBDriverContext result = this.context;
        if (result == null) {
            ADBDriverBase aDBDriverBase = this;
            synchronized (aDBDriverBase) {
                result = this.context;
                if (result == null) {
                    this.context = result = this.createDriverContext();
                }
            }
        }
        return result;
    }

    protected ADBDriverContext createDriverContext() {
        return new ADBDriverContext(this.getOrCreateDriverVersion(), this.errorReporter, this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ADBProductVersion getOrCreateDriverVersion() {
        ADBProductVersion result = this.driverVersion;
        if (result == null) {
            ADBDriverBase aDBDriverBase = this;
            synchronized (aDBDriverBase) {
                result = this.driverVersion;
                if (result == null) {
                    this.driverVersion = result = this.getDriverVersion();
                }
            }
        }
        return result;
    }

    protected abstract ADBProductVersion getDriverVersion();

    protected Collection<ADBDriverProperty> getSupportedProperties() {
        return Arrays.asList(ADBDriverProperty.Common.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ADBDriverProperty> getOrCreateSupportedPropertiesIndex() {
        Map<String, ADBDriverProperty> result = this.supportedPropertiesIndex;
        if (result == null) {
            ADBDriverBase aDBDriverBase = this;
            synchronized (aDBDriverBase) {
                result = this.supportedPropertiesIndex;
                if (result == null) {
                    this.supportedPropertiesIndex = result = ADBDriverBase.createPropertyIndexByName(this.getSupportedProperties());
                }
            }
        }
        return result;
    }

    private static Map<String, ADBDriverProperty> createPropertyIndexByName(Collection<ADBDriverProperty> properties) {
        LinkedHashMap<String, ADBDriverProperty> m = new LinkedHashMap<String, ADBDriverProperty>();
        for (ADBDriverProperty p : properties) {
            m.put(p.getPropertyName(), p);
        }
        return Collections.unmodifiableMap(m);
    }

    public void checkDriverVersion(Map<ADBDriverProperty, Object> properties) throws SQLException {
        ADBProductVersion driverVersion;
        ADBProductVersion minExpectedVersion = (ADBProductVersion)ADBDriverProperty.Common.MIN_DRIVER_VERSION.fetchPropertyValue(properties);
        if (minExpectedVersion != null && !(driverVersion = this.getOrCreateDriverVersion()).isAtLeast(minExpectedVersion)) {
            throw this.errorReporter.errorUnexpectedDriverVersion(driverVersion, minExpectedVersion);
        }
    }

    public void checkDatabaseVersion(Map<ADBDriverProperty, Object> properties, ADBProductVersion databaseVersion) throws SQLException {
        ADBProductVersion minExpectedVersion = (ADBProductVersion)ADBDriverProperty.Common.MIN_DATABASE_VERSION.fetchPropertyValue(properties);
        if (minExpectedVersion != null && !databaseVersion.isAtLeast(minExpectedVersion)) {
            throw this.errorReporter.errorUnexpectedDatabaseVersion(databaseVersion, minExpectedVersion);
        }
    }

    protected ADBErrorReporter createErrorReporter() {
        return new ADBErrorReporter();
    }

    protected abstract ADBProtocolBase createProtocol(String var1, int var2, Map<ADBDriverProperty, Object> var3, ADBDriverContext var4) throws SQLException;

    protected ADBConnection createConnection(ADBProtocolBase protocol, String url, ADBProductVersion databaseVersion, String dataverseCanonicalName, Map<ADBDriverProperty, Object> properties, SQLWarning connectWarning) throws SQLException {
        return new ADBConnection(protocol, url, databaseVersion, dataverseCanonicalName, properties, connectWarning);
    }

    protected abstract Properties getURIParameters(URI var1) throws SQLException;
}

