/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.util.Objects;
import java.util.logging.Logger;
import org.apache.asterix.jdbc.core.ADBErrorReporter;
import org.apache.asterix.jdbc.core.ADBProductVersion;
import org.apache.asterix.jdbc.core.ADBRowStore;
import org.apache.asterix.jdbc.core.ADBStatement;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.annotation.PropertyAccessor;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.asterix.jdbc.core.deps.com.fasterxml.jackson.databind.module.SimpleModule;

public class ADBDriverContext {
    private final ADBProductVersion driverVersion;
    private final ADBErrorReporter errorReporter;
    private final Logger logger;
    private final ObjectReader genericObjectReader;
    private final ObjectWriter genericObjectWriter;
    private final ObjectReader admFormatObjectReader;
    private final ObjectWriter admFormatObjectWriter;

    public ADBDriverContext(ADBProductVersion driverVersion, ADBErrorReporter errorReporter, Logger logger) {
        this.driverVersion = Objects.requireNonNull(driverVersion);
        this.errorReporter = Objects.requireNonNull(errorReporter);
        this.logger = Objects.requireNonNull(logger);
        ObjectMapper genericObjectMapper = this.createGenericObjectMapper();
        this.genericObjectReader = genericObjectMapper.reader();
        this.genericObjectWriter = genericObjectMapper.writer();
        ObjectMapper admFormatObjectMapper = this.createADMFormatObjectMapper();
        this.admFormatObjectReader = admFormatObjectMapper.reader();
        this.admFormatObjectWriter = admFormatObjectMapper.writer();
    }

    protected ObjectMapper createGenericObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NON_PRIVATE);
        om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        om.enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        return om;
    }

    protected ObjectMapper createADMFormatObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule serdeModule = new SimpleModule(this.getClass().getName());
        ADBStatement.configureADMFormatSerialization(serdeModule);
        ADBRowStore.configureADMFormatDeserialization(mapper, serdeModule);
        mapper.registerModule(serdeModule);
        return mapper;
    }

    public ADBErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ObjectReader getGenericObjectReader() {
        return this.genericObjectReader;
    }

    public ObjectWriter getGenericObjectWriter() {
        return this.genericObjectWriter;
    }

    public ObjectReader getAdmFormatObjectReader() {
        return this.admFormatObjectReader;
    }

    public ObjectWriter getAdmFormatObjectWriter() {
        return this.admFormatObjectWriter;
    }

    public ADBProductVersion getDriverVersion() {
        return this.driverVersion;
    }
}

