/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantNameAndType
extends Constant {
    private int name_index;
    private int signature_index;

    public ConstantNameAndType(ConstantNameAndType c) {
        this(c.getNameIndex(), c.getSignatureIndex());
    }

    ConstantNameAndType(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public ConstantNameAndType(int name_index, int signature_index) {
        super((byte)12);
        this.name_index = name_index;
        this.signature_index = signature_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantNameAndType(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public String getName(ConstantPool cp) {
        return cp.constantToString(this.getNameIndex(), (byte)1);
    }

    public int getSignatureIndex() {
        return this.signature_index;
    }

    public String getSignature(ConstantPool cp) {
        return cp.constantToString(this.getSignatureIndex(), (byte)1);
    }

    public void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    @Override
    public String toString() {
        return super.toString() + "(name_index = " + this.name_index + ", signature_index = " + this.signature_index + ")";
    }
}

