/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms.iowrappers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.axiom.ext.activation.SizeAwareDataSource;
import org.apache.axis2.transport.jms.iowrappers.BytesMessageInputStream;
import org.apache.axis2.transport.jms.iowrappers.JMSExceptionWrapper;

public class BytesMessageDataSource
implements SizeAwareDataSource {
    private final BytesMessage message;
    private final String contentType;

    public BytesMessageDataSource(BytesMessage message, String contentType) {
        this.message = message;
        this.contentType = contentType;
    }

    public BytesMessageDataSource(BytesMessage message) {
        this(message, "application/octet-stream");
    }

    public long getSize() {
        try {
            return this.message.getBodyLength();
        }
        catch (JMSException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.message.reset();
        }
        catch (JMSException ex) {
            throw new JMSExceptionWrapper(ex);
        }
        return new BytesMessageInputStream(this.message);
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

