/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.Map;
import org.apache.axis2.kernel.TransportListener;
import org.apache.axis2.kernel.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.TransportViewMBean;

public class TransportView
implements TransportViewMBean {
    private ManagementSupport managementSupport = null;
    private TransportListener listener = null;
    private TransportSender sender = null;

    public TransportView(TransportListener listener, TransportSender sender) {
        if (listener != null) {
            this.listener = listener;
            if (listener instanceof ManagementSupport) {
                this.managementSupport = (ManagementSupport)listener;
            }
        }
        if (sender != null) {
            this.sender = sender;
            if (sender instanceof ManagementSupport) {
                this.managementSupport = (ManagementSupport)sender;
            }
        }
    }

    @Override
    public long getMessagesReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMessagesReceived();
        }
        return -1L;
    }

    @Override
    public long getFaultsReceiving() {
        if (this.managementSupport != null) {
            return this.managementSupport.getFaultsReceiving();
        }
        return -1L;
    }

    @Override
    public long getTimeoutsReceiving() {
        if (this.managementSupport != null) {
            return this.managementSupport.getTimeoutsReceiving();
        }
        return -1L;
    }

    @Override
    public long getTimeoutsSending() {
        if (this.managementSupport != null) {
            this.managementSupport.getTimeoutsSending();
        }
        return -1L;
    }

    @Override
    public long getBytesReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getBytesReceived();
        }
        return -1L;
    }

    @Override
    public long getMessagesSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMessagesSent();
        }
        return -1L;
    }

    @Override
    public long getFaultsSending() {
        if (this.managementSupport != null) {
            return this.managementSupport.getFaultsSending();
        }
        return -1L;
    }

    @Override
    public long getBytesSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getBytesSent();
        }
        return -1L;
    }

    @Override
    public long getMinSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMinSizeReceived();
        }
        return -1L;
    }

    @Override
    public long getMaxSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMaxSizeReceived();
        }
        return -1L;
    }

    @Override
    public double getAvgSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getAvgSizeReceived();
        }
        return -1.0;
    }

    @Override
    public long getMinSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMinSizeSent();
        }
        return -1L;
    }

    @Override
    public long getMaxSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMaxSizeSent();
        }
        return -1L;
    }

    @Override
    public double getAvgSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getAvgSizeSent();
        }
        return -1.0;
    }

    @Override
    public Map getResponseCodeTable() {
        if (this.managementSupport != null) {
            return this.managementSupport.getResponseCodeTable();
        }
        return null;
    }

    @Override
    public int getActiveThreadCount() {
        if (this.managementSupport != null) {
            return this.managementSupport.getActiveThreadCount();
        }
        return -1;
    }

    @Override
    public int getQueueSize() {
        if (this.managementSupport != null) {
            return this.managementSupport.getQueueSize();
        }
        return -1;
    }

    @Override
    public void start() throws Exception {
        if (this.listener != null) {
            this.listener.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        } else if (this.sender != null) {
            this.sender.stop();
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.pause();
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.resume();
        }
    }

    @Override
    public void maintenenceShutdown(long seconds) throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.maintenenceShutdown(seconds * 1000L);
        }
    }

    @Override
    public void resetStatistics() {
        if (this.managementSupport != null) {
            this.managementSupport.resetStatistics();
        }
    }

    @Override
    public long getLastResetTime() {
        if (this.managementSupport != null) {
            return this.managementSupport.getLastResetTime();
        }
        return -1L;
    }

    @Override
    public long getMetricsWindow() {
        if (this.managementSupport != null) {
            return System.currentTimeMillis() - this.managementSupport.getLastResetTime();
        }
        return -1L;
    }
}

