/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AtMostOnceInterceptor
extends ChannelInterceptorBase {
    private static Log log = LogFactory.getLog(AtMostOnceInterceptor.class);
    private static final Map<MessageId, Long> receivedMessages = new HashMap<MessageId, Long>();
    private static final int TIMEOUT = 300000;

    public AtMostOnceInterceptor() {
        Thread cleanupThread = new Thread(new MessageCleanupTask());
        cleanupThread.setPriority(1);
        cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelMessage msg) {
        if (this.okToProcess(msg.getOptions())) {
            Map<MessageId, Long> map = receivedMessages;
            synchronized (map) {
                MessageId msgId = new MessageId(msg.getUniqueId());
                if (receivedMessages.get(msgId) == null) {
                    receivedMessages.put(msgId, System.currentTimeMillis());
                    super.messageReceived(msg);
                } else {
                    log.info((Object)("Duplicate message received from " + TribesUtil.getName(msg.getAddress())));
                }
            }
        } else {
            super.messageReceived(msg);
        }
    }

    private static class MessageCleanupTask
    implements Runnable {
        private MessageCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    ArrayList<MessageId> toBeRemoved = new ArrayList<MessageId>();
                    Thread.yield();
                    Map<MessageId, Long> map = receivedMessages;
                    synchronized (map) {
                        for (MessageId msgId : receivedMessages.keySet()) {
                            long arrivalTime = receivedMessages.get(msgId);
                            if (System.currentTimeMillis() - arrivalTime < 300000L) continue;
                            toBeRemoved.add(msgId);
                            if (toBeRemoved.size() <= 10000) continue;
                            break;
                        }
                        for (MessageId msgId : toBeRemoved) {
                            receivedMessages.remove(msgId);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Cleaned up message ");
                        }
                        continue;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Exception occurred while trying to cleanup messages", e);
                    continue;
                }
                break;
            }
        }
    }

    private static class MessageId {
        private byte[] id;

        private MessageId(byte[] id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MessageId messageId = (MessageId)o;
            return Arrays.equals(this.id, messageId.id);
        }

        public int hashCode() {
            return Arrays.hashCode(this.id);
        }
    }
}

