/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import java.util.Iterator;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.intf.AxiomDocument;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSerializable;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomDocumentMixin
implements AxiomDocument {
    public final OMElement getOMDocumentElement() {
        try {
            return (OMElement)this.coreGetDocumentElement();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void setOMDocumentElement(OMElement documentElement) {
        try {
            if (documentElement == null) {
                throw new IllegalArgumentException("documentElement must not be null");
            }
            AxiomElement existingDocumentElement = (AxiomElement)this.coreGetDocumentElement();
            if (existingDocumentElement == null) {
                this.addChild((OMNode)documentElement);
            } else {
                existingDocumentElement.coreReplaceWith((AxiomElement)documentElement, AxiomSemantics.INSTANCE);
            }
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final String getCharsetEncoding() {
        String inputEncoding = this.coreGetInputEncoding();
        return inputEncoding == null ? "UTF-8" : inputEncoding;
    }

    public final void setCharsetEncoding(String charsetEncoding) {
        this.coreSetInputEncoding(charsetEncoding);
    }

    public final String getXMLVersion() {
        return this.coreGetXmlVersion();
    }

    public final void setXMLVersion(String xmlVersion) {
        this.coreSetXmlVersion(xmlVersion);
    }

    public final String getXMLEncoding() {
        return this.coreGetXmlEncoding();
    }

    public final void setXMLEncoding(String xmlEncoding) {
        this.coreSetXmlEncoding(xmlEncoding);
    }

    public final String isStandalone() {
        Boolean standalone = this.coreGetStandalone();
        if (standalone == null) {
            return null;
        }
        return standalone != false ? "yes" : "no";
    }

    public final void setStandalone(String standalone) {
        this.coreSetStandalone("yes".equalsIgnoreCase(standalone));
    }

    @Override
    public final void checkChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.getOMDocumentElement() != null) {
                throw new OMException("Document element already exists");
            }
            this.checkDocumentElement((OMElement)child);
        }
    }

    public void checkDocumentElement(OMElement element) {
    }

    @Override
    public final CoreElement getContextElement() {
        return null;
    }

    public Iterator<OMSerializable> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomSerializable.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }
}

