/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.stream.xop.CountingOutputStream;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OptimizationPolicyImpl
implements OptimizationPolicy {
    private static final Log log = LogFactory.getLog(OptimizationPolicyImpl.class);
    private final OMOutputFormat format;

    public OptimizationPolicyImpl(OMOutputFormat format) {
        this.format = format;
    }

    @Override
    public boolean isOptimized(Blob blob, boolean optimize) {
        if (!optimize) {
            return false;
        }
        int threshold = this.format.getOptimizedThreshold();
        if (threshold == 0) {
            return true;
        }
        long size = blob.getSize();
        if (size != -1L) {
            return size > (long)threshold;
        }
        try {
            blob.writeTo((OutputStream)new CountingOutputStream(threshold));
            return false;
        }
        catch (StreamCopyException ex) {
            if (ex.getOperation() == 2) {
                return true;
            }
            log.warn((Object)"Blob.writeTo(OutputStream) threw IOException", ex.getCause());
            return true;
        }
    }

    @Override
    public boolean isOptimized(BlobProvider blobProvider, boolean optimize) throws IOException {
        if (!optimize) {
            return false;
        }
        if (this.format.getOptimizedThreshold() == 0) {
            return true;
        }
        return this.isOptimized(blobProvider.getBlob(), optimize);
    }
}

