/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.BaseSAML2MessageEncoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.message.handler.HandlerChain;
import org.opensaml.ws.message.handler.HandlerChainAware;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.message.handler.HandlerException;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HandlerChainAwareHTTPSOAP11Encoder
extends BaseSAML2MessageEncoder
implements HandlerChainAware {
    private final Logger log = LoggerFactory.getLogger(HandlerChainAwareHTTPSOAP11Encoder.class);
    private SOAPObjectBuilder<Envelope> envBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;
    private boolean notConfidential = false;

    public HandlerChainAwareHTTPSOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
    }

    public boolean isNotConfidential() {
        return this.notConfidential;
    }

    public void setNotConfidential(boolean flag) {
        this.notConfidential = flag;
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        if (this.notConfidential) {
            return false;
        }
        return messageContext.getOutboundMessageTransport().isConfidential();
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isIntegrityProtected();
    }

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
        this.prepareMessageContext(messageContext);
        this.processOutboundHandlerChain(messageContext);
        this.encodeToTransport(messageContext);
    }

    protected void prepareMessageContext(MessageContext messageContext) throws MessageEncodingException {
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object samlMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (samlMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        this.signMessage(samlMsgCtx);
        this.log.debug("Building SOAP envelope");
        Envelope envelope = (Envelope)this.envBuilder.buildObject();
        Body body = (Body)this.bodyBuilder.buildObject();
        envelope.setBody(body);
        body.getUnknownXMLObjects().add(samlMessage);
        messageContext.setOutboundMessage((XMLObject)envelope);
    }

    protected void encodeToTransport(MessageContext messageContext) throws MessageEncodingException {
        Element envelopeElem = this.marshallMessage(messageContext.getOutboundMessage());
        this.preprocessTransport(messageContext);
        try {
            OutTransport outTransport = messageContext.getOutboundMessageTransport();
            OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
            XMLHelper.writeNode((Node)envelopeElem, (Writer)out);
            ((Writer)out).flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("JVM does not support required UTF-8 encoding");
            throw new MessageEncodingException("JVM does not support required UTF-8 encoding");
        }
        catch (IOException e) {
            this.log.error("Unable to write message content to outbound stream", (Throwable)e);
            throw new MessageEncodingException("Unable to write message content to outbound stream", (Exception)e);
        }
    }

    protected void preprocessTransport(MessageContext messageContext) throws MessageEncodingException {
        HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
        HTTPTransportUtils.addNoCacheHeaders((HTTPOutTransport)outTransport);
        HTTPTransportUtils.setUTF8Encoding((HTTPOutTransport)outTransport);
        HTTPTransportUtils.setContentType((HTTPOutTransport)outTransport, (String)"text/xml");
        outTransport.setHeader("SOAPAction", "http://www.oasis-open.org/committees/security");
    }

    protected void processOutboundHandlerChain(MessageContext messageContext) throws MessageEncodingException {
        HandlerChainResolver outboundHandlerChainResolver = messageContext.getOutboundHandlerChainResolver();
        if (outboundHandlerChainResolver != null) {
            this.log.debug("Invoking outbound handler chain on message context");
            try {
                for (HandlerChain outboundHandlerChain : outboundHandlerChainResolver.resolve(messageContext)) {
                    if (outboundHandlerChain == null) continue;
                    this.invokeHandlerChain(outboundHandlerChain, messageContext);
                }
            }
            catch (HandlerException e) {
                this.log.error("Encountered HandlerException when encoding message: {}", (Object)e.getMessage());
                throw new MessageEncodingException("Handler exception while encoding message", (Exception)((Object)e));
            }
        }
    }

    protected void invokeHandlerChain(HandlerChain handlerChain, MessageContext messageContext) throws HandlerException {
        if (handlerChain != null && messageContext != null) {
            handlerChain.invoke(messageContext);
        }
    }
}

