/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandeshaReport {
    private ArrayList<String> incomingSequenceList = new ArrayList();
    private ArrayList<String> outgoingSequenceList = new ArrayList();
    private HashMap<String, Byte> sequenceStatusMap = new HashMap();
    private HashMap<String, Long> noOfCompletedMessagesMap = new HashMap();
    private HashMap<String, String> outgoingInternalSequenceIDMap = new HashMap();

    public long getCompletedMessagesCount(String sequenceID) {
        Long lng = this.noOfCompletedMessagesMap.get(sequenceID);
        if (lng == null) {
            return -1L;
        }
        return lng;
    }

    public List<String> getIncomingSequenceList() {
        return this.incomingSequenceList;
    }

    public List<String> getOutgoingSequenceList() {
        return this.outgoingSequenceList;
    }

    public byte getSequenceStatusMap(String sequenceID) {
        Byte status = this.sequenceStatusMap.get(sequenceID);
        if (status == null) {
            return 0;
        }
        return status;
    }

    public void addToIncomingSequenceList(String incomingSequenceID) {
        this.incomingSequenceList.add(incomingSequenceID);
    }

    public void addToOutgoingSequenceList(String outSequenceID) {
        this.outgoingSequenceList.add(outSequenceID);
    }

    public void addToNoOfCompletedMessagesMap(String id, long noOfMsgs) {
        this.noOfCompletedMessagesMap.put(id, new Long(noOfMsgs));
    }

    public void addToSequenceStatusMap(String id, byte status) {
        this.sequenceStatusMap.put(id, new Byte(status));
    }

    public String getInternalSequenceIdOfOutSequence(String outSequenceID) {
        return this.outgoingInternalSequenceIDMap.get(outSequenceID);
    }

    public void addToOutgoingInternalSequenceMap(String outSequenceID, String internalSequenceID) {
        this.outgoingInternalSequenceIDMap.put(outSequenceID, internalSequenceID);
    }
}

