/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull
implements Provider<LoginCredentials> {
    private final ValueOfConfigurationKeyOrNull config;
    private final String provider;
    private final Map<String, Credentials> credentialStore;

    @Inject
    public GetLoginForProviderFromPropertiesAndStoreCredentialsOrReturnNull(@org.jclouds.location.Provider String provider, ValueOfConfigurationKeyOrNull config, Map<String, Credentials> credentialStore) {
        this.config = (ValueOfConfigurationKeyOrNull)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.provider = (String)Preconditions.checkNotNull((Object)provider, (Object)"provider");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    @Nullable
    public LoginCredentials get() {
        LoginCredentials creds;
        String authenticateSudo;
        if (this.credentialStore.containsKey("image")) {
            return LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("image"));
        }
        LoginCredentials.Builder builder = LoginCredentials.builder();
        String loginUser = this.config.apply(this.provider + ".image.login-user");
        if (loginUser == null) {
            loginUser = this.config.apply("jclouds.image.login-user");
        }
        if (loginUser != null) {
            int pos = loginUser.indexOf(58);
            if (pos != -1) {
                builder.user(loginUser.substring(0, pos)).password(loginUser.substring(pos + 1));
            } else {
                builder.user(loginUser);
            }
        }
        if ((authenticateSudo = this.config.apply(this.provider + ".image.authenticate-sudo")) == null) {
            authenticateSudo = this.config.apply("jclouds.image.authenticate-sudo");
        }
        if (authenticateSudo != null) {
            builder.authenticateSudo(Boolean.valueOf(authenticateSudo).booleanValue());
        }
        if ((creds = builder.build()) != null) {
            this.credentialStore.put("image", (Credentials)creds);
        }
        return creds;
    }
}

