/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.karaf.commands;

import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="brooklyn", name="application-list", description="Lists all applications")
@Service
public class ApplicationList
implements Action {
    @Reference
    private ManagementContext managementContext;

    public Object execute() throws Exception {
        System.out.println();
        ShellTable table = new ShellTable();
        table.column("id");
        table.column("name");
        table.column("up");
        table.column("state");
        table.column("expected state");
        this.managementContext.getApplications().forEach(application -> table.addRow().addContent(new Object[]{application.getApplicationId(), application.getDisplayName(), ((Boolean)application.sensors().get(Attributes.SERVICE_UP)).toString(), ((Lifecycle)application.sensors().get(Attributes.SERVICE_STATE_ACTUAL)).toString(), ((Lifecycle.Transition)application.sensors().get(Attributes.SERVICE_STATE_EXPECTED)).toString()}));
        table.print(System.out, true);
        System.out.println();
        return null;
    }
}

