/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.jclouds.azurecompute.arm.compute.domain.LocationAndName;
import org.jclouds.azurecompute.arm.domain.VMHardware;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;

public class VMHardwareToHardware
implements Function<VMHardware, Hardware> {
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    VMHardwareToHardware(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    public Hardware apply(VMHardware from) {
        HardwareBuilder builder = new HardwareBuilder().name(from.name()).providerId(from.name()).id(LocationAndName.fromLocationAndName(from.location(), from.name()).slashEncode()).processors((Iterable)ImmutableList.of((Object)new Processor((double)from.numberOfCores().intValue(), 2.0))).ram(from.memoryInMB().intValue()).location((Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)from.location())).get());
        if (from.resourceDiskSizeInMB() != null) {
            builder.volume(new VolumeBuilder().size(Float.valueOf(from.resourceDiskSizeInMB().intValue())).type(Volume.Type.LOCAL).build());
        }
        if (from.osDiskSizeInMB() != null) {
            builder.volume(new VolumeBuilder().size(Float.valueOf(from.osDiskSizeInMB().intValue())).type(Volume.Type.LOCAL).build());
        }
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"maxDataDiskCount", (Object)String.valueOf(from.maxDataDiskCount()));
        builder.userMetadata((Map)metadata.build());
        return builder.build();
    }
}

