/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ZoneAndName {
    public static final Function<ZoneAndName, String> NAME_FUNCTION = new Function<ZoneAndName, String>(){

        public String apply(ZoneAndName input) {
            return input.getName();
        }
    };
    public static final Function<ZoneAndName, String> ZONE_FUNCTION = new Function<ZoneAndName, String>(){

        public String apply(ZoneAndName input) {
            return input.getZone();
        }
    };
    protected final String zoneId;
    protected final String name;

    public static ZoneAndName fromZoneAndName(String zoneId, String name) {
        return new ZoneAndName(zoneId, name);
    }

    protected ZoneAndName(String zoneId, String name) {
        this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (Object)"zoneId");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public String getZone() {
        return this.zoneId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneAndName that = (ZoneAndName)ZoneAndName.class.cast(o);
        return Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneId, this.name});
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("zoneId", (Object)this.zoneId).add("name", (Object)this.name);
    }
}

