/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.core.location.cloud.names.BasicCloudMachineNamer;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.util.core.config.ConfigBag;

public class JcloudsMachineNamer
extends BasicCloudMachineNamer {
    public Integer getCustomMaxNameLength(ConfigBag setup) {
        if ("vcloud".equals(setup.peek(JcloudsLocationConfig.CLOUD_PROVIDER))) {
            return 24;
        }
        if ("abiquo".equals(setup.peek(JcloudsLocationConfig.CLOUD_PROVIDER))) {
            return 39;
        }
        if ("google-compute-engine".equals(setup.peek(JcloudsLocationConfig.CLOUD_PROVIDER))) {
            return 39;
        }
        if ("softlayer".equals(setup.peek(JcloudsLocationConfig.CLOUD_PROVIDER))) {
            return 55;
        }
        return null;
    }

    protected String generateNewIdOfLength(ConfigBag setup, int len) {
        String pattern = (String)setup.get(CloudLocationConfig.VM_NAME_ALLOWED_CHARACTERS);
        if ((pattern == null || pattern == CloudLocationConfig.VM_NAME_ALLOWED_CHARACTERS.getDefaultValue()) && "azurecompute-arm".equals(setup.peek(JcloudsLocationConfig.CLOUD_PROVIDER))) {
            setup.put(CloudLocationConfig.VM_NAME_ALLOWED_CHARACTERS, (Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890");
        }
        return super.generateNewIdOfLength(setup, len);
    }
}

