/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.cm.salt.SaltConfig;
import org.apache.brooklyn.entity.cm.salt.SaltEntityImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=SaltEntityImpl.class)
@Catalog(name="SaltEntity", description="Software managed by Salt CM")
public interface SaltEntity
extends SoftwareProcess,
SaltConfig {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)BrooklynConfigKeys.SUGGESTED_VERSION, (Object)"stable");
    public static final AttributeSensor<List<String>> STATES = Sensors.newSensor((TypeToken)new TypeToken<List<String>>(){}, (String)"salt.states", (String)"Salt Highstate states");
    public static final MethodEffector<String> SALT_CALL = new MethodEffector(SaltEntity.class, "saltCall");

    @Effector(description="Invoke a Salt command")
    public String saltCall(@EffectorParam(name="spec", description="Name and optional arguments of a Salt command") String var1);
}

