/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.rest.domain.HasName;

public class EntitySpec
implements HasName,
Serializable {
    private static final long serialVersionUID = -3882575609132757188L;
    private final String name;
    private final String type;
    private final Map<String, String> config;

    public EntitySpec(String type) {
        this(null, type);
    }

    public EntitySpec(String name, String type) {
        this(name, type, Collections.emptyMap());
    }

    public EntitySpec(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="config") Map<String, String> config) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.name = name == null ? type : name;
        this.config = config != null ? ImmutableMap.copyOf(config) : ImmutableMap.of();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntitySpec)) {
            return false;
        }
        EntitySpec that = (EntitySpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.config);
    }

    public String toString() {
        return "EntitySpec{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", config=" + this.config + '}';
    }
}

