/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Section;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.internal.BaseVirtualSystem;
import org.jclouds.ovf.xml.OperatingSystemSectionHandler;
import org.jclouds.ovf.xml.ProductSectionHandler;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.ovf.xml.VirtualHardwareSectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BaseVirtualSystemHandler<T extends BaseVirtualSystem<T>, B extends BaseVirtualSystem.Builder<T>>
extends SectionHandler<T, B> {
    private final OperatingSystemSectionHandler osHandler;
    private final VirtualHardwareSectionHandler hardwareHandler;
    private final ProductSectionHandler productHandler;
    protected SectionHandler defaultSectionHandler = SectionHandler.create();
    protected Map<String, Provider<? extends SectionHandler>> extensionHandlers = ImmutableMap.of();
    protected SectionHandler extensionHandler;
    private boolean inHardware;
    private boolean inOs;
    private boolean inProduct;
    private boolean inSection;
    private boolean inExtensionSection;
    private int depth;

    @Inject
    public BaseVirtualSystemHandler(Provider<B> builderProvider, OperatingSystemSectionHandler osHandler, VirtualHardwareSectionHandler hardwareHandler, ProductSectionHandler productHandler) {
        super(builderProvider);
        this.osHandler = osHandler;
        this.hardwareHandler = hardwareHandler;
        this.productHandler = productHandler;
    }

    @Inject(optional=true)
    protected void setExtensionHandlers(@Named(value="VirtualSystem") Map<String, Provider<? extends SectionHandler>> extensionHandlers) {
        this.extensionHandlers = ImmutableMap.builder().putAll(this.extensionHandlers).putAll(extensionHandlers).build();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        ++this.depth;
        if (this.depth == 2) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualHardwareSection")) {
                this.inHardware = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"OperatingSystemSection")) {
                this.inOs = true;
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ProductSection")) {
                this.inProduct = true;
            } else if (this.extensionHandlers.containsKey(qName)) {
                this.inExtensionSection = true;
                this.extensionHandler = (SectionHandler)((Object)this.extensionHandlers.get(qName).get());
            } else if (attributes.containsKey("type") && this.extensionHandlers.containsKey(attributes.get("type"))) {
                this.inExtensionSection = true;
                this.extensionHandler = (SectionHandler)((Object)this.extensionHandlers.get(attributes.get("type")).get());
            } else if (qName.endsWith("Section")) {
                this.inSection = true;
            }
        }
        if (this.inHardware) {
            this.hardwareHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inOs) {
            this.osHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inProduct) {
            this.productHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inExtensionSection) {
            this.extensionHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inSection) {
            this.defaultSectionHandler.startElement(uri, localName, qName, attrs);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualSystem")) {
            ((BaseVirtualSystem.Builder)this.builder).id((String)attributes.get("id"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        --this.depth;
        if (this.depth == 1) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"VirtualHardwareSection")) {
                this.inHardware = false;
                ((BaseVirtualSystem.Builder)this.builder).virtualHardwareSection((VirtualHardwareSection)this.hardwareHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"OperatingSystemSection")) {
                this.inOs = false;
                ((BaseVirtualSystem.Builder)this.builder).operatingSystemSection((OperatingSystemSection)this.osHandler.getResult());
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ProductSection")) {
                this.inProduct = false;
                ((BaseVirtualSystem.Builder)this.builder).productSection((ProductSection)this.productHandler.getResult());
            } else if (this.extensionHandlers.containsKey(qName)) {
                this.addAdditionalSection(qName, (Section)this.extensionHandler.getResult());
                this.inSection = false;
                this.inExtensionSection = false;
            } else if (qName.endsWith("Section")) {
                this.addAdditionalSection(qName, (Section)(this.inExtensionSection ? this.extensionHandler.getResult() : this.defaultSectionHandler.getResult()));
                this.inSection = false;
                this.inExtensionSection = false;
            }
        }
        if (this.inHardware) {
            this.hardwareHandler.endElement(uri, localName, qName);
        } else if (this.inOs) {
            this.osHandler.endElement(uri, localName, qName);
        } else if (this.inProduct) {
            this.productHandler.endElement(uri, localName, qName);
        } else if (this.inExtensionSection) {
            this.extensionHandler.endElement(uri, localName, qName);
        } else if (this.inSection) {
            this.defaultSectionHandler.endElement(uri, localName, qName);
        } else {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
                ((BaseVirtualSystem.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Name")) {
                ((BaseVirtualSystem.Builder)this.builder).name(SaxUtils.currentOrNull((StringBuilder)this.currentText));
            }
            super.endElement(uri, localName, qName);
        }
    }

    protected void addAdditionalSection(String qName, Section additionalSection) {
        ((BaseVirtualSystem.Builder)this.builder).additionalSection(qName, additionalSection);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inHardware) {
            this.hardwareHandler.characters(ch, start, length);
        } else if (this.inOs) {
            this.osHandler.characters(ch, start, length);
        } else if (this.inProduct) {
            this.productHandler.characters(ch, start, length);
        } else if (this.inExtensionSection) {
            this.extensionHandler.characters(ch, start, length);
        } else if (this.inSection) {
            this.defaultSectionHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }
}

