/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.policy.AbstractInvokeEffectorPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.text.StringPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeEffectorOnSensorChange
extends AbstractInvokeEffectorPolicy
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeEffectorOnSensorChange.class);
    public static final ConfigKey<Object> SENSOR = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Object.class).name("sensor")).description("Sensor to be monitored, as string or sensor type")).constraint(Predicates.notNull())).build();
    public static final ConfigKey<String> EFFECTOR = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class).name("effector")).description("Name of effector to invoke")).constraint(StringPredicates.isNonBlank())).build();
    private AttributeSensor<Object> sensor;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Preconditions.checkNotNull((Object)this.getConfig(EFFECTOR), EFFECTOR);
        this.sensor = this.getSensor();
        this.subscriptions().subscribe((Entity)entity, this.sensor, this);
        LOG.debug("{} subscribed to {} events on {}", new Object[]{this, this.sensor, entity});
    }

    public void onEvent(SensorEvent<Object> event) {
        Effector eff = (Effector)this.getEffectorNamed(this.getConfig(EFFECTOR)).get();
        if (this.isBusySensorEnabled()) {
            Object currentSensorValue = this.entity.sensors().get(this.sensor);
            this.setMoreUpdatesComing(event.getTimestamp(), event.getValue(), currentSensorValue);
        }
        this.invoke(eff, (Map<String, ?>)MutableMap.of());
    }

    private AttributeSensor<Object> getSensor() {
        Object configVal = Preconditions.checkNotNull((Object)this.getConfig(SENSOR), SENSOR);
        if (configVal == null) {
            throw new NullPointerException("Value for " + SENSOR.getName() + " is null");
        }
        AttributeSensor sensor = configVal instanceof String ? Sensors.newSensor(Object.class, (String)configVal) : (configVal instanceof AttributeSensor ? (AttributeSensor)configVal : (AttributeSensor)TypeCoercions.tryCoerce(configVal, new TypeToken<AttributeSensor<Object>>(){}).get());
        return sensor;
    }
}

