/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.http.utils.Queries;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.options.ListOptions;

public class HrefToListOptions
implements Function<Href, ListOptions> {
    public ListOptions apply(Href input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null");
        Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)URI.create(input.href()).getQuery());
        String nextPage = HrefToListOptions.getFirstOrNull("page", (Multimap<String, String>)queryParams);
        String nextPerPage = HrefToListOptions.getFirstOrNull("per_page", (Multimap<String, String>)queryParams);
        ListOptions options = new ListOptions();
        if (nextPage != null) {
            options.page(Integer.parseInt(nextPage));
        }
        if (nextPerPage != null) {
            options.perPage(Integer.parseInt(nextPerPage));
        }
        return options;
    }

    public static String getFirstOrNull(String key, Multimap<String, String> params) {
        return params.containsKey((Object)key) ? Strings.emptyToNull((String)((String)Iterables.getFirst((Iterable)params.get((Object)key), null))) : null;
    }
}

