/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;

public class ContainerStateBuilder
extends ContainerStateFluent<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateBuilder() {
        this(false);
    }

    public ContainerStateBuilder(Boolean validationEnabled) {
        this(new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this(fluent, instance, false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        ContainerState containerState = instance = instance != null ? instance : new ContainerState();
        if (instance != null) {
            fluent.withRunning(instance.getRunning());
            fluent.withTerminated(instance.getTerminated());
            fluent.withWaiting(instance.getWaiting());
            fluent.withRunning(instance.getRunning());
            fluent.withTerminated(instance.getTerminated());
            fluent.withWaiting(instance.getWaiting());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateBuilder(ContainerState instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerState instance, Boolean validationEnabled) {
        this.fluent = this;
        ContainerState containerState = instance = instance != null ? instance : new ContainerState();
        if (instance != null) {
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerState build() {
        ContainerState buildable = new ContainerState(this.fluent.buildRunning(), this.fluent.buildTerminated(), this.fluent.buildWaiting());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

