/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_ResourceDefinition;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class ResourceDefinition {
    public abstract String name();

    public abstract String type();

    public abstract String location();

    public abstract String apiVersion();

    @Nullable
    public abstract List<String> dependsOn();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract Object properties();

    @SerializedNames(value={"name", "type", "location", "apiVersion", "dependsOn", "tags", "properties"})
    public static ResourceDefinition create(String name, String type, String location, String apiVersion, List<String> dependsOn, Map<String, String> tags, Object properties) {
        Builder builder = ResourceDefinition.builder().name(name).type(type).location(location).apiVersion(apiVersion).properties(properties);
        builder.dependsOn((List<String>)(dependsOn == null ? null : ImmutableList.copyOf(dependsOn)));
        builder.tags((Map<String, String>)(tags == null ? null : ImmutableMap.copyOf(tags)));
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ResourceDefinition.Builder();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder type(String var1);

        public abstract Builder location(String var1);

        public abstract Builder apiVersion(String var1);

        public abstract Builder dependsOn(List<String> var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(Object var1);

        abstract List<String> dependsOn();

        abstract Map<String, String> tags();

        abstract ResourceDefinition autoBuild();

        public ResourceDefinition build() {
            this.dependsOn((List<String>)(this.dependsOn() != null ? ImmutableList.copyOf(this.dependsOn()) : null));
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null));
            return this.autoBuild();
        }
    }
}

