/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityType;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.CatalogApi;
import org.apache.brooklyn.rest.domain.CatalogEnricherSummary;
import org.apache.brooklyn.rest.domain.CatalogEntitySummary;
import org.apache.brooklyn.rest.domain.CatalogItemSummary;
import org.apache.brooklyn.rest.domain.CatalogLocationSummary;
import org.apache.brooklyn.rest.domain.CatalogPolicySummary;
import org.apache.brooklyn.rest.domain.SummaryComparators;
import org.apache.brooklyn.rest.transform.ConfigTransformer;
import org.apache.brooklyn.rest.transform.EffectorTransformer;
import org.apache.brooklyn.rest.transform.SensorTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CatalogTransformer {
    private static final Logger log = LoggerFactory.getLogger(CatalogTransformer.class);

    public static <T extends Entity> CatalogEntitySummary catalogEntitySummary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        EntitySpec spec;
        TreeSet effectors;
        TreeSet sensors;
        LinkedHashSet config;
        block6: {
            config = Sets.newLinkedHashSet();
            sensors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            effectors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            spec = null;
            try {
                spec = (EntitySpec)b.getTypeRegistry().createSpec(item, null, EntitySpec.class);
                EntityDynamicType typeMap = BrooklynTypes.getDefinedEntityType((Class)spec.getType());
                EntityType type = typeMap.getSnapshot();
                AtomicInteger priority = new AtomicInteger();
                for (SpecParameter input : spec.getParameters()) {
                    config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyEntityConfig());
                }
                for (Sensor x : type.getSensors()) {
                    sensors.add(SensorTransformer.sensorSummaryForCatalog(x));
                }
                for (Sensor x : type.getEffectors()) {
                    effectors.add(EffectorTransformer.effectorSummaryForCatalog(b.mgmt(), x));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (item.getSuperTypes().contains(Entity.class)) {
                    log.warn("Unable to create spec for " + item + ": " + e, (Throwable)e);
                }
                if (!log.isTraceEnabled()) break block6;
                log.trace("Unable to create spec for " + item + ": " + e, (Throwable)e);
            }
        }
        return new CatalogEntitySummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), spec != null ? spec.getType().getName() : item.getSuperTypes().toString(), spec != null ? CatalogItem.CatalogItemType.ofTargetClass((Class)spec.getType()).name() : "unknown", RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), CatalogTransformer.makeTags(spec, item), (Set)config, (Set)sensors, (Set)effectors, item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    public static CatalogItemSummary catalogItemSummary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        try {
            if (item.getSuperTypes().contains(Application.class) || item.getSuperTypes().contains(Entity.class)) {
                return CatalogTransformer.catalogEntitySummary(b, item, ub);
            }
            if (item.getSuperTypes().contains(Policy.class)) {
                return CatalogTransformer.catalogPolicySummary(b, item, ub);
            }
            if (item.getSuperTypes().contains(Enricher.class)) {
                return CatalogTransformer.catalogEnricherSummary(b, item, ub);
            }
            if (item.getSuperTypes().contains(Location.class)) {
                return CatalogTransformer.catalogLocationSummary(b, item, ub);
            }
            log.debug("Misc catalog item type when getting self link (supplying generic item): " + item + " " + item.getSuperTypes());
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Invalid item in catalog when converting REST summaries (supplying generic item), at " + item + ": " + e, (Throwable)e);
        }
        return new CatalogItemSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getSuperTypes().toString(), item.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.BEAN ? "bean" : "unknown", RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), item.getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    public static CatalogPolicySummary catalogPolicySummary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        LinkedHashSet config = Sets.newLinkedHashSet();
        PolicySpec spec = null;
        try {
            spec = (PolicySpec)b.getTypeRegistry().createSpec(item, null, PolicySpec.class);
            AtomicInteger priority = new AtomicInteger();
            for (SpecParameter input : spec.getParameters()) {
                config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyPolicyConfig());
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.trace("Unable to create policy spec for " + item + ": " + e, (Throwable)e);
        }
        return new CatalogPolicySummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), spec != null ? spec.getType().getName() : item.getSuperTypes().toString(), CatalogItem.CatalogItemType.POLICY.toString(), RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    public static CatalogEnricherSummary catalogEnricherSummary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        LinkedHashSet config = Sets.newLinkedHashSet();
        EnricherSpec spec = null;
        try {
            spec = (EnricherSpec)b.getTypeRegistry().createSpec(item, null, EnricherSpec.class);
            AtomicInteger priority = new AtomicInteger();
            for (SpecParameter input : spec.getParameters()) {
                config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyEnricherConfig());
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.trace("Unable to create policy spec for " + item + ": " + e, (Throwable)e);
        }
        return new CatalogEnricherSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), spec != null ? spec.getType().getName() : item.getSuperTypes().toString(), CatalogItem.CatalogItemType.ENRICHER.toString(), RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    public static CatalogLocationSummary catalogLocationSummary(BrooklynRestResourceUtils b, RegisteredType item, UriBuilder ub) {
        ImmutableSet config = ImmutableSet.of();
        return new CatalogLocationSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getSuperTypes().toString(), CatalogItem.CatalogItemType.LOCATION.toString(), RegisteredTypes.getImplementationDataStringForSpec((RegisteredType)item), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    protected static Map<String, URI> makeLinks(RegisteredType item, UriBuilder ub) {
        return MutableMap.of().addIfNotNull((Object)"self", (Object)CatalogTransformer.getSelfLink(item, ub));
    }

    protected static URI getSelfLink(RegisteredType item, UriBuilder ub) {
        String itemId = item.getId();
        if (item.getSuperTypes().contains(Application.class)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getApplication").build(new Object[]{itemId, item.getVersion()});
        }
        if (item.getSuperTypes().contains(Entity.class)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getEntity").build(new Object[]{itemId, item.getVersion()});
        }
        if (item.getSuperTypes().contains(Policy.class)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getPolicy").build(new Object[]{itemId, item.getVersion()});
        }
        if (item.getSuperTypes().contains(Enricher.class)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getEnricher").build(new Object[]{itemId, item.getVersion()});
        }
        if (item.getSuperTypes().contains(Location.class)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getLocation").build(new Object[]{itemId, item.getVersion()});
        }
        log.warn("Unexpected catalog item type when getting self link (not supplying self link): " + item + " " + item.getSuperTypes());
        return null;
    }

    private static String tidyIconLink(BrooklynRestResourceUtils b, RegisteredType item, String iconUrl, UriBuilder ub) {
        if (b.isUrlServerSideAndSafe(iconUrl)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getIcon").build(new Object[]{item.getSymbolicName(), item.getVersion()}).toString();
        }
        return iconUrl;
    }

    private static Set<Object> makeTags(EntitySpec<?> spec, RegisteredType item) {
        return CatalogTransformer.makeTags(spec, (Set<Object>)MutableSet.copyOf((Iterable)item.getTags()));
    }

    private static Set<Object> makeTags(EntitySpec<?> spec, CatalogItem<?, ?> item) {
        return CatalogTransformer.makeTags(spec, (Set<Object>)MutableSet.copyOf((Iterable)item.tags().getTags()));
    }

    private static Set<Object> makeTags(EntitySpec<?> spec, Set<Object> tags) {
        Class type;
        if (spec != null && (type = spec.getImplementation() != null ? spec.getImplementation() : spec.getType()) != null) {
            tags.add(new BrooklynTags.TraitsTag(Reflections.getAllInterfaces((Class)type)));
        }
        return tags;
    }

    @Deprecated
    public static <T extends Entity> CatalogEntitySummary catalogEntitySummary(BrooklynRestResourceUtils b, CatalogItem<T, EntitySpec<? extends T>> item, UriBuilder ub) {
        EntitySpec spec;
        TreeSet effectors;
        TreeSet sensors;
        LinkedHashSet config;
        block6: {
            config = Sets.newLinkedHashSet();
            sensors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            effectors = Sets.newTreeSet((Comparator)SummaryComparators.nameComparator());
            spec = null;
            try {
                spec = (EntitySpec)b.getCatalog().peekSpec(item);
                EntityDynamicType typeMap = BrooklynTypes.getDefinedEntityType((Class)spec.getType());
                EntityType type = typeMap.getSnapshot();
                AtomicInteger priority = new AtomicInteger();
                for (SpecParameter input : spec.getParameters()) {
                    config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyEntityConfig());
                }
                for (Sensor x : type.getSensors()) {
                    sensors.add(SensorTransformer.sensorSummaryForCatalog(x));
                }
                for (Sensor x : type.getEffectors()) {
                    effectors.add(EffectorTransformer.effectorSummaryForCatalog(b.mgmt(), x));
                }
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (item.getCatalogItemType() == CatalogItem.CatalogItemType.ENTITY) {
                    log.warn("Unable to create spec for " + item + ": " + e, (Throwable)e);
                }
                if (!log.isTraceEnabled()) break block6;
                log.trace("Unable to create spec for " + item + ": " + e, (Throwable)e);
            }
        }
        return new CatalogEntitySummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getJavaType(), item.getCatalogItemType().toString(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), CatalogTransformer.makeTags(spec, item), (Set)config, (Set)sensors, (Set)effectors, item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    @Deprecated
    public static CatalogItemSummary catalogItemSummary(BrooklynRestResourceUtils b, CatalogItem item, UriBuilder ub) {
        try {
            switch (item.getCatalogItemType()) {
                case TEMPLATE: 
                case APPLICATION: 
                case ENTITY: {
                    return CatalogTransformer.catalogEntitySummary(b, item, ub);
                }
                case POLICY: {
                    return CatalogTransformer.catalogPolicySummary(b, item, ub);
                }
                case ENRICHER: {
                    return CatalogTransformer.catalogEnricherSummary(b, item, ub);
                }
                case LOCATION: {
                    return CatalogTransformer.catalogLocationSummary(b, item, ub);
                }
            }
            log.warn("Unexpected catalog item type when getting self link (supplying generic item): " + item.getCatalogItemType() + " " + item);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Invalid item in catalog when converting REST summaries (supplying generic item), at " + item + ": " + e, (Throwable)e);
        }
        return new CatalogItemSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getJavaType(), item.getCatalogItemType().toString(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), item.tags().getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    @Deprecated
    public static CatalogPolicySummary catalogPolicySummary(BrooklynRestResourceUtils b, CatalogItem<? extends Policy, PolicySpec<?>> item, UriBuilder ub) {
        LinkedHashSet config = Sets.newLinkedHashSet();
        try {
            PolicySpec spec = (PolicySpec)b.getCatalog().peekSpec(item);
            AtomicInteger priority = new AtomicInteger();
            for (SpecParameter input : spec.getParameters()) {
                config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyPolicyConfig());
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.trace("Unable to create policy spec for " + item + ": " + e, (Throwable)e);
        }
        return new CatalogPolicySummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getJavaType(), item.getCatalogItemType().toString(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.tags().getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    @Deprecated
    public static CatalogEnricherSummary catalogEnricherSummary(BrooklynRestResourceUtils b, CatalogItem<? extends Enricher, EnricherSpec<?>> item, UriBuilder ub) {
        LinkedHashSet config = Sets.newLinkedHashSet();
        try {
            EnricherSpec spec = (EnricherSpec)b.getCatalog().peekSpec(item);
            AtomicInteger priority = new AtomicInteger();
            for (SpecParameter input : spec.getParameters()) {
                config.add(ConfigTransformer.of(input).uiIncrementAndSetPriorityIfPinned(priority).transformLegacyEnricherConfig());
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.trace("Unable to create policy spec for " + item + ": " + e, (Throwable)e);
        }
        return new CatalogEnricherSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getJavaType(), item.getCatalogItemType().toString(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.tags().getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    @Deprecated
    public static CatalogLocationSummary catalogLocationSummary(BrooklynRestResourceUtils b, CatalogItem<? extends Location, LocationSpec<?>> item, UriBuilder ub) {
        ImmutableSet config = ImmutableSet.of();
        return new CatalogLocationSummary(item.getSymbolicName(), item.getVersion(), item.getContainingBundle(), item.getDisplayName(), item.getJavaType(), item.getCatalogItemType().toString(), item.getPlanYaml(), item.getDescription(), CatalogTransformer.tidyIconLink(b, item, item.getIconUrl(), ub), (Set)config, item.tags().getTags(), item.isDeprecated(), CatalogTransformer.makeLinks(item, ub));
    }

    private static Map<String, URI> makeLinks(CatalogItem<?, ?> item, UriBuilder ub) {
        return MutableMap.of().addIfNotNull((Object)"self", (Object)CatalogTransformer.getSelfLink(item, ub));
    }

    private static URI getSelfLink(CatalogItem<?, ?> item, UriBuilder ub) {
        String itemId = item.getId();
        switch (item.getCatalogItemType()) {
            case TEMPLATE: 
            case APPLICATION: {
                return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getApplication").build(new Object[]{itemId, item.getVersion()});
            }
            case ENTITY: {
                return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getEntity").build(new Object[]{itemId, item.getVersion()});
            }
            case POLICY: {
                return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getPolicy").build(new Object[]{itemId, item.getVersion()});
            }
            case ENRICHER: {
                return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getEnricher").build(new Object[]{itemId, item.getVersion()});
            }
            case LOCATION: {
                return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getLocation").build(new Object[]{itemId, item.getVersion()});
            }
        }
        log.warn("Unexpected catalog item type when getting self link (not supplying self link): " + item.getCatalogItemType() + " " + item);
        return null;
    }

    private static String tidyIconLink(BrooklynRestResourceUtils b, CatalogItem<?, ?> item, String iconUrl, UriBuilder ub) {
        if (b.isUrlServerSideAndSafe(iconUrl)) {
            return WebResourceUtils.serviceUriBuilder(ub, CatalogApi.class, "getIcon").build(new Object[]{item.getSymbolicName(), item.getVersion()}).toString();
        }
        return iconUrl;
    }
}

