/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Future;
import javax.ws.rs.core.MediaType;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.rest.domain.ApplicationSpec;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.PrimitiveStringTypeCoercions;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynRestResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynRestResourceUtils.class);
    private final ManagementContext mgmt;

    public BrooklynRestResourceUtils(ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.mgmt = mgmt;
    }

    public ManagementContext mgmt() {
        return this.mgmt;
    }

    public BrooklynTypeRegistry getTypeRegistry() {
        return this.mgmt.getTypeRegistry();
    }

    public BrooklynCatalog getCatalog() {
        return this.mgmt.getCatalog();
    }

    public ClassLoader getCatalogClassLoader() {
        return this.mgmt.getCatalogClassLoader();
    }

    public LocationRegistry getLocationRegistry() {
        return this.mgmt.getLocationRegistry();
    }

    public Policy getPolicy(String application, String entity, String policy) {
        return this.getPolicy(this.getEntity(application, entity), policy);
    }

    public EntityAdjunct getAdjunct(String application, String entity, String adjunct) {
        return this.getAdjunct(this.getEntity(application, entity), adjunct);
    }

    public Policy getPolicy(Entity entity, String policy) {
        if (policy == null) {
            return null;
        }
        for (Policy p : entity.policies()) {
            if (!policy.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : entity.policies()) {
            if (!policy.equals(p.getDisplayName())) continue;
            return p;
        }
        throw WebResourceUtils.notFound("Cannot find policy '%s' in entity '%s'", policy, entity);
    }

    public EntityAdjunct getAdjunct(Entity entity, String adjunct) {
        if (adjunct == null) {
            return null;
        }
        for (Policy p : entity.policies()) {
            if (!adjunct.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : entity.enrichers()) {
            if (!adjunct.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : ((EntityInternal)entity).feeds()) {
            if (!adjunct.equals(p.getId())) continue;
            return p;
        }
        for (Policy p : entity.policies()) {
            if (!adjunct.equals(p.getDisplayName())) continue;
            return p;
        }
        for (Policy p : entity.enrichers()) {
            if (!adjunct.equals(p.getDisplayName())) continue;
            return p;
        }
        for (Policy p : ((EntityInternal)entity).feeds()) {
            if (!adjunct.equals(p.getDisplayName())) continue;
            return p;
        }
        throw WebResourceUtils.notFound("Cannot find adjunct '%s' in entity '%s'", adjunct, entity);
    }

    public Entity getEntity(String application, String entity) {
        if (entity == null) {
            return null;
        }
        Application app = application != null ? this.getApplication(application) : null;
        Entity e = this.mgmt.getEntityManager().getEntity(entity);
        if (e != null) {
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)e)) {
                throw WebResourceUtils.notFound("Cannot find entity '%s': no known ID and application not supplied for searching", entity);
            }
            if (app == null || app.equals(this.findTopLevelApplication(e))) {
                return e;
            }
            throw WebResourceUtils.preconditionFailed("Application '%s' specified does not match application '%s' to which entity '%s' (%s) is associated", application, e.getApplication() == null ? null : e.getApplication().getId(), entity, e);
        }
        if (application == null) {
            throw WebResourceUtils.notFound("Cannot find entity '%s': no known ID and application not supplied for searching", entity);
        }
        assert (app != null) : "null app should not be returned from getApplication";
        e = this.searchForEntityNamed((Entity)app, entity);
        if (e != null) {
            return e;
        }
        throw WebResourceUtils.notFound("Cannot find entity '%s' in application '%s' (%s)", entity, application, app);
    }

    private Application findTopLevelApplication(Entity e) {
        Application app;
        for (app = e.getApplication(); app != null && !app.equals(app.getApplication()); app = app.getApplication()) {
        }
        return app;
    }

    public Application getApplication(String application) {
        Entity e = this.mgmt.getEntityManager().getEntity(application);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)e)) {
            throw WebResourceUtils.notFound("Application '%s' not found", application);
        }
        if (e != null && e instanceof Application) {
            return (Application)e;
        }
        for (Application app : this.mgmt.getApplications()) {
            if (app.getId().equals(application)) {
                return app;
            }
            if (!application.equalsIgnoreCase(app.getDisplayName())) continue;
            return app;
        }
        throw WebResourceUtils.notFound("Application '%s' not found", application);
    }

    public Entity searchForEntityNamed(Entity root, String entity) {
        if (root.getId().equals(entity) || entity.equals(root.getDisplayName())) {
            return root;
        }
        for (Entity child : root.getChildren()) {
            Entity result = this.searchForEntityNamed(child, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Application create(ApplicationSpec spec) {
        log.warn("Using deprecated functionality (as of 0.9.0), ApplicationSpec style (pre CAMP plans). Transition to actively supported spec plans.");
        log.debug("REST creating application instance for {}", (Object)spec);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.DEPLOY_APPLICATION, (Object)spec)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to deploy application %s", Entitlements.getEntitlementContext().user(), spec);
        }
        String type = spec.getType();
        String name = spec.getName();
        Map configO = spec.getConfig();
        Object entities = spec.getEntities() == null ? ImmutableSet.of() : spec.getEntities();
        FindItemAndClass itemAndClass = Strings.isEmpty((CharSequence)type) ? new FindItemAndClass().setAs(BasicApplication.class, null) : new FindItemAndClass().inferFrom(type);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt.getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to create application from applicationSpec %s", Entitlements.getEntitlementContext().user(), spec);
        }
        try {
            Application instance;
            if (Application.class.isAssignableFrom(itemAndClass.clazz)) {
                EntitySpec<?> coreSpec = this.toCoreEntitySpec(itemAndClass.clazz, name, configO, itemAndClass.catalogItemId);
                this.configureRenderingMetadata(spec, coreSpec);
                Iterator iterator = entities.iterator();
                while (iterator.hasNext()) {
                    org.apache.brooklyn.rest.domain.EntitySpec entitySpec = (org.apache.brooklyn.rest.domain.EntitySpec)iterator.next();
                    log.info("REST creating instance for entity {}", (Object)entitySpec.getType());
                    coreSpec.child(this.toCoreEntitySpec(entitySpec));
                }
                log.info("REST placing '{}' under management", (Object)(spec.getName() != null ? spec.getName() : spec));
                instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
            } else if (Entity.class.isAssignableFrom(itemAndClass.clazz)) {
                if (entities.size() > 0) {
                    log.warn("Cannot supply additional entities when using a non-application entity; ignoring in spec {}", (Object)spec);
                }
                EntitySpec<?> coreSpec = this.toCoreEntitySpec(BasicApplication.class, name, configO, itemAndClass.catalogItemId);
                this.configureRenderingMetadata(spec, coreSpec);
                coreSpec.child((EntitySpec)this.toCoreEntitySpec(itemAndClass.clazz, name, configO, itemAndClass.catalogItemId).configure(BrooklynCampConstants.PLAN_ID, (Object)"soleChildId"));
                coreSpec.enricher(((Enrichers.PropagatorBuilder)Enrichers.builder().propagatingAllBut(new Sensor[]{Attributes.SERVICE_UP, Attributes.SERVICE_NOT_UP_INDICATORS, Attributes.SERVICE_STATE_ACTUAL, Attributes.SERVICE_STATE_EXPECTED, Attributes.SERVICE_PROBLEMS}).from(new DslComponent(DslComponent.Scope.CHILD, "soleChildId").newTask())).build());
                log.info("REST placing '{}' under management", (Object)spec.getName());
                instance = (Application)this.mgmt.getEntityManager().createEntity(coreSpec);
            } else {
                throw new IllegalArgumentException("Class " + itemAndClass.clazz + " must extend one of ApplicationBuilder, Application or Entity");
            }
            return instance;
        }
        catch (Exception e) {
            log.error("REST failed to create application: " + e, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Task<?> start(Application app, ApplicationSpec spec) {
        return this.start(app, this.getLocationsManaged(spec));
    }

    public Task<?> start(Application app, List<? extends Location> locations) {
        return Entities.invokeEffector((Entity)app, (Entity)app, (Effector)Startable.START, (Map)MutableMap.of((Object)"locations", locations));
    }

    public List<Location> getLocationsManaged(ApplicationSpec spec) {
        Function<String, Location> buildLocationFromId = new Function<String, Location>(){

            public Location apply(String id) {
                id = BrooklynRestResourceUtils.fixLocation(id);
                return BrooklynRestResourceUtils.this.getLocationRegistry().getLocationManaged(id);
            }
        };
        ArrayList locations = Lists.newArrayList((Iterable)Iterables.transform((Iterable)spec.getLocations(), (Function)buildLocationFromId));
        return locations;
    }

    private EntitySpec<? extends Entity> toCoreEntitySpec(org.apache.brooklyn.rest.domain.EntitySpec spec) {
        String type = spec.getType();
        String name = spec.getName();
        LinkedHashMap config = spec.getConfig() == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap((Map)spec.getConfig());
        FindItemAndClass itemAndClass = new FindItemAndClass().inferFrom(type);
        Class<? extends Entity> clazz = itemAndClass.clazz;
        EntitySpec result = clazz.isInterface() ? EntitySpec.create(clazz) : EntitySpec.create(Entity.class).impl(clazz).additionalInterfaces((Iterable)Reflections.getAllInterfaces(clazz));
        result.catalogItemId(itemAndClass.catalogItemId);
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getType(), config));
        this.configureRenderingMetadata(spec, result);
        return result;
    }

    protected void configureRenderingMetadata(ApplicationSpec input, EntitySpec<?> entity) {
        entity.configure(this.getRenderingConfigurationFor(input.getType()));
    }

    protected void configureRenderingMetadata(org.apache.brooklyn.rest.domain.EntitySpec input, EntitySpec<?> entity) {
        entity.configure(this.getRenderingConfigurationFor(input.getType()));
    }

    protected Map<?, ?> getRenderingConfigurationFor(String catalogId) {
        MutableMap result = MutableMap.of();
        RegisteredType item = this.mgmt.getTypeRegistry().get(catalogId);
        if (item == null) {
            return result;
        }
        result.addIfNotNull((Object)"iconUrl", (Object)item.getIconUrl());
        return result;
    }

    private <T extends Entity> EntitySpec<?> toCoreEntitySpec(Class<T> clazz, String name, Map<String, String> configO, String catalogItemId) {
        EntitySpec result;
        LinkedHashMap config;
        LinkedHashMap linkedHashMap = config = configO == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(configO);
        if (clazz.isInterface()) {
            result = EntitySpec.create(clazz);
        } else {
            Class interfaceclazz = Application.class.isAssignableFrom(clazz) ? Application.class : Entity.class;
            Set additionalInterfaceClazzes = Reflections.getInterfacesIncludingClassAncestors(clazz);
            result = EntitySpec.create(interfaceclazz).impl(clazz).additionalInterfaces((Iterable)additionalInterfaceClazzes);
        }
        result.catalogItemId(catalogItemId);
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(this.convertFlagsToKeys(result.getImplementation(), config));
        return result;
    }

    private Map<?, ?> convertFlagsToKeys(Class<? extends Entity> javaType, Map<?, ?> config) {
        if (config == null || config.isEmpty() || javaType == null) {
            return config;
        }
        Map configKeys = BrooklynTypes.getDefinedConfigKeys(javaType);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : config.entrySet()) {
            log.debug("Setting key {} to {} for REST creation of {}", new Object[]{entry.getKey(), entry.getValue(), javaType});
            Object key = configKeys.get(entry.getKey());
            if (key == null) {
                log.warn("Unrecognised config key {} passed to {}; will be treated as flag (and likely ignored)", entry.getKey(), javaType);
                key = entry.getKey();
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    public Task<?> destroy(final Application application) {
        return this.mgmt.getExecutionManager().submit((Map)MutableMap.of((Object)"displayName", (Object)("destroying " + application), (Object)"description", (Object)("REST call to destroy application " + application.getDisplayName() + " (" + application + ")")), new Runnable(){

            @Override
            public void run() {
                ((EntityInternal)application).destroy();
                BrooklynRestResourceUtils.this.mgmt.getEntityManager().unmanage((Entity)application);
            }
        });
    }

    public Task<?> expunge(final Entity entity, final boolean release) {
        if (this.mgmt.getEntitlementManager().isEntitled(Entitlements.getEntitlementContext(), Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)"expunge", (Object)MutableMap.of((Object)"release", (Object)release))))) {
            MutableMap flags = MutableMap.of((Object)"displayName", (Object)("expunging " + entity), (Object)"description", (Object)("REST call to expunge entity " + entity.getDisplayName() + " (" + entity + ")"));
            if (Entitlements.getEntitlementContext() != null) {
                flags.put("tags", MutableSet.of((Object)BrooklynTaskTags.ENTITY_DESTRUCTION, (Object)BrooklynTaskTags.tagForEntitlement((EntitlementContext)Entitlements.getEntitlementContext())));
            }
            return this.mgmt.getExecutionManager().submit((Map)flags, new Runnable(){

                @Override
                public void run() {
                    if (release) {
                        Entities.destroy((Entity)entity, (boolean)false);
                    } else {
                        BrooklynRestResourceUtils.this.mgmt.getEntityManager().unmanage(entity);
                    }
                }
            });
        }
        throw WebResourceUtils.forbidden("User '%s' is not authorized to expunge entity %s", Entitlements.getEntitlementContext().user(), entity);
    }

    @Deprecated
    public static String fixLocation(String locationId) {
        if (locationId.startsWith("/locations/") || locationId.startsWith("/v1/locations/")) {
            log.warn("REST API using legacy URI syntax for location: " + locationId);
            locationId = Strings.removeFromStart((String)locationId, (String)"/v1/locations/");
            locationId = Strings.removeFromStart((String)locationId, (String)"/locations/");
        }
        return locationId;
    }

    public Object getObjectValueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Future && ((Future)value).isDone()) {
            try {
                value = ((Future)value).get();
            }
            catch (Exception e) {
                value = "" + value + " (error evaluating: " + e + ")";
            }
        }
        if (PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(value.getClass())) {
            return value;
        }
        return value.toString();
    }

    public String getStringValueForDisplay(Object value) {
        if (value == null) {
            return null;
        }
        return "" + this.getObjectValueForDisplay(value);
    }

    public boolean isUrlServerSideAndSafe(String url) {
        if (Strings.isEmpty((CharSequence)url)) {
            return false;
        }
        String ext = Files.getFileExtension((String)url);
        if (Strings.isEmpty((CharSequence)ext)) {
            return false;
        }
        MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(ext);
        if (mime == null) {
            return false;
        }
        return !Urls.isUrlWithProtocol((String)url) || url.startsWith("classpath:");
    }

    public Iterable<Entity> descendantsOfAnyType(String application, String entity) {
        ArrayList result = Lists.newArrayList();
        Entity e = this.getEntity(application, entity);
        BrooklynRestResourceUtils.gatherAllDescendants(e, result);
        return result;
    }

    private static void gatherAllDescendants(Entity e, List<Entity> result) {
        if (result.add(e)) {
            for (Entity ee : e.getChildren()) {
                BrooklynRestResourceUtils.gatherAllDescendants(ee, result);
            }
        }
    }

    public Iterable<Entity> descendantsOfType(String application, String entity, final String typeRegex) {
        Iterable<Entity> result = this.descendantsOfAnyType(application, entity);
        return Iterables.filter(result, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                if (entity == null) {
                    return false;
                }
                return entity.getEntityType().getName().matches(typeRegex);
            }
        });
    }

    public void reloadBrooklynProperties() {
        this.mgmt.reloadBrooklynProperties();
    }

    private class FindItemAndClass {
        String catalogItemId;
        Class<? extends Entity> clazz;

        private FindItemAndClass() {
        }

        private FindItemAndClass inferFrom(String type) {
            RegisteredType item = BrooklynRestResourceUtils.this.mgmt.getTypeRegistry().get(type);
            if (item != null) {
                return this.setAs(((EntitySpec)BrooklynRestResourceUtils.this.mgmt.getTypeRegistry().createSpec(item, null, EntitySpec.class)).getType(), item.getId());
            }
            try {
                this.setAs(BrooklynRestResourceUtils.this.getCatalog().getRootClassLoader().loadClass(type), null);
                log.info("Catalog does not contain item for type {}; loaded class directly instead", (Object)type);
                return this;
            }
            catch (ClassNotFoundException e2) {
                log.warn("No catalog item for type {}, and could not load class directly; rethrowing", (Object)type);
                throw new NoSuchElementException("Unable to find catalog item for type " + type);
            }
        }

        private FindItemAndClass setAs(Class<? extends Entity> clazz, String catalogItemId) {
            this.clazz = clazz;
            this.catalogItemId = catalogItemId;
            return this;
        }
    }
}

