/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.internal.StringSystemProperty;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.Secret;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;

public final class Sanitizer {
    public static final ConfigKey<List<String>> SENSITIVE_FIELDS_TOKENS = BrooklynServerConfig.SENSITIVE_FIELDS_TOKENS;
    public static final ConfigKey<Boolean> SENSITIVE_FIELDS_PLAINTEXT_BLOCKED = BrooklynServerConfig.SENSITIVE_FIELDS_PLAINTEXT_BLOCKED;
    public static final ConfigKey<List<String>> SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES = BrooklynServerConfig.SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES;
    public static final List<String> DEFAULT_SENSITIVE_FIELDS_TOKENS = ImmutableList.of((Object)"password", (Object)"passwd", (Object)"credential", (Object)"secret", (Object)"private", (Object)"access.cert", (Object)"access.key");
    public static final List<String> SECRET_NAMES = DEFAULT_SENSITIVE_FIELDS_TOKENS;
    private static List<String> LAST_SENSITIVE_FIELDS_TOKENS = null;
    private static Boolean LAST_SENSITIVE_FIELDS_PLAINTEXT_BLOCKED = null;
    private static List<String> LAST_SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES = null;
    private static long LAST_SENSITIVE_FIELDS_LOAD_TIME = -1L;
    private static long LAST_SENSITIVE_FIELDS_CACHE_MILLIS = 60000L;
    public static final Predicate<Object> IS_SECRET_PREDICATE = new IsSecretPredicate();
    @Deprecated
    private static final Predicate<Object> IS_SECRET_PREDICATE_DEPRECATED = new Predicate<Object>(){

        public boolean apply(Object name) {
            if (name == null) {
                return false;
            }
            String lowerName = name.toString().toLowerCase();
            for (String secretName : Sanitizer.getSensitiveFieldsTokens()) {
                if (!lowerName.contains(secretName)) continue;
                return true;
            }
            return false;
        }
    };
    private Predicate<Object> predicate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refreshProperties(Boolean refresh) {
        if (Boolean.FALSE.equals(refresh) || refresh == null && LAST_SENSITIVE_FIELDS_LOAD_TIME + LAST_SENSITIVE_FIELDS_CACHE_MILLIS > System.currentTimeMillis()) {
            return;
        }
        Class<Sanitizer> clazz = Sanitizer.class;
        synchronized (Sanitizer.class) {
            if (LAST_SENSITIVE_FIELDS_LOAD_TIME < 0L) {
                refresh = true;
            }
            if (refresh == null) {
                refresh = LAST_SENSITIVE_FIELDS_LOAD_TIME + LAST_SENSITIVE_FIELDS_CACHE_MILLIS < System.currentTimeMillis();
            }
            if (refresh.booleanValue()) {
                StringSystemProperty extPhrasesSP;
                StringSystemProperty plaintextSP;
                StringSystemProperty tokensSP;
                ManagementContext mgmt = Osgis.getManagementContext();
                List tokens = null;
                Boolean plaintextBlocked = null;
                Object extPhrases = null;
                if (mgmt != null) {
                    tokens = (List)mgmt.getConfig().getConfig(SENSITIVE_FIELDS_TOKENS);
                    plaintextBlocked = (Boolean)mgmt.getConfig().getConfig(SENSITIVE_FIELDS_PLAINTEXT_BLOCKED);
                    extPhrases = (List)mgmt.getConfig().getConfig(SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES);
                }
                if (tokens == null && (tokensSP = new StringSystemProperty(SENSITIVE_FIELDS_TOKENS.getName())).isNonEmpty()) {
                    tokens = (List)TypeCoercions.coerce((Object)tokensSP.getValue(), SENSITIVE_FIELDS_TOKENS.getTypeToken());
                }
                if (tokens == null) {
                    tokens = DEFAULT_SENSITIVE_FIELDS_TOKENS;
                }
                if (plaintextBlocked == null && (plaintextSP = new StringSystemProperty(SENSITIVE_FIELDS_PLAINTEXT_BLOCKED.getName())).isNonEmpty()) {
                    plaintextBlocked = (Boolean)TypeCoercions.coerce((Object)plaintextSP.getValue(), SENSITIVE_FIELDS_PLAINTEXT_BLOCKED.getTypeToken());
                }
                if (plaintextBlocked == null) {
                    plaintextBlocked = Boolean.FALSE;
                }
                if (extPhrases == null && (extPhrasesSP = new StringSystemProperty(SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES.getName())).isNonEmpty()) {
                    extPhrases = (List)TypeCoercions.coerce((Object)extPhrasesSP.getValue(), SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES.getTypeToken());
                }
                if (extPhrases == null) {
                    extPhrases = MutableList.of();
                }
                LAST_SENSITIVE_FIELDS_TOKENS = tokens.stream().map(String::toLowerCase).collect(Collectors.toList());
                LAST_SENSITIVE_FIELDS_PLAINTEXT_BLOCKED = plaintextBlocked;
                LAST_SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES = extPhrases;
                LAST_SENSITIVE_FIELDS_LOAD_TIME = System.currentTimeMillis();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<String> getSensitiveFieldsTokens() {
        return Sanitizer.getSensitiveFieldsTokens(null);
    }

    public static List<String> getSensitiveFieldsTokens(Boolean refresh) {
        Sanitizer.refreshProperties(refresh);
        return LAST_SENSITIVE_FIELDS_TOKENS;
    }

    public static boolean isSensitiveFieldsPlaintextBlocked() {
        return Sanitizer.isSensitiveFieldsPlaintextBlocked(null);
    }

    public static boolean isSensitiveFieldsPlaintextBlocked(Boolean refresh) {
        Sanitizer.refreshProperties(refresh);
        return LAST_SENSITIVE_FIELDS_PLAINTEXT_BLOCKED;
    }

    public static List<String> getSensitiveFieldsExtBlockedPhrases() {
        return Sanitizer.getSensitiveFieldsExtBlockedPhrases(null);
    }

    public static List<String> getSensitiveFieldsExtBlockedPhrases(Boolean refresh) {
        Sanitizer.refreshProperties(refresh);
        return LAST_SENSITIVE_FIELDS_EXT_BLOCKED_PHRASES;
    }

    public static Object suppressIfSecret(Object key, Object value) {
        if (value != null && IS_SECRET_PREDICATE.apply(key)) {
            return Sanitizer.suppress(value);
        }
        return value;
    }

    public static String suppress(Object value) {
        return Secret.SecretHelper.suppress((Object)value);
    }

    public static String suppressJson(Object value, boolean excludeBrooklynDslExpressions) {
        if (value == null || Boxing.isPrimitiveOrBoxedObject((Object)value) || value instanceof CharSequence) {
            if (excludeBrooklynDslExpressions && value instanceof String && ((String)value).startsWith("$brooklyn:")) {
                return (String)value;
            }
            return Sanitizer.suppress(value);
        }
        return Sanitizer.suppress(new Gson().toJson(value));
    }

    public static String suppressIfSecret(Object key, String value) {
        if (value != null && IS_SECRET_PREDICATE.apply(key)) {
            return Sanitizer.suppress(value);
        }
        return value;
    }

    public static String sanitizeMultilineString(String input) {
        if (input == null) {
            return null;
        }
        return Arrays.stream(input.split("\n")).map(line -> {
            String key;
            Integer first = Arrays.asList(line.indexOf("="), line.indexOf(":")).stream().filter(x -> x > 0).min(Integer::compare).orElse(null);
            if (first != null && IS_SECRET_PREDICATE.apply((Object)(key = line.substring(0, first)))) {
                String value = line.substring(first + 1);
                return key + line.substring(first, first + 1) + (Strings.isBlank((CharSequence)value) ? value : " " + Sanitizer.suppress(value.trim()));
            }
            return line;
        }).collect(Collectors.joining("\n"));
    }

    public static void sanitizeMapToString(Map<?, ?> env, StringBuilder sb) {
        if (env != null) {
            for (Map.Entry<?, ?> kv : env.entrySet()) {
                String stringValue;
                String string = stringValue = kv.getValue() != null ? kv.getValue().toString() : "";
                if (!stringValue.isEmpty()) {
                    stringValue = Sanitizer.suppressIfSecret(kv.getKey(), stringValue);
                    stringValue = Sanitizer.sanitizeMultilineString(stringValue);
                    stringValue = StringEscapes.BashStringEscapes.wrapBash((String)stringValue);
                }
                sb.append(kv.getKey()).append("=").append(stringValue).append("\n");
            }
        }
    }

    public static <K> K sanitizeJsonTypes(K obj) {
        return Sanitizer.newInstance().apply(obj);
    }

    public static Object suppressNestedSecretsJson(Object x, boolean excludeBrooklynDslExpressions) {
        if (x == null || Boxing.isPrimitiveOrBoxedObject((Object)x)) {
            return x;
        }
        if (x instanceof CharSequence) {
            return Sanitizer.sanitizeMultilineString(x.toString());
        }
        if (x instanceof Map) {
            MutableMap y = MutableMap.of();
            ((Map)x).forEach((arg_0, arg_1) -> Sanitizer.lambda$suppressNestedSecretsJson$2((Map)y, excludeBrooklynDslExpressions, arg_0, arg_1));
            return y;
        }
        if (x instanceof Iterable) {
            MutableList y = MutableList.of();
            ((Iterable)x).forEach(arg_0 -> Sanitizer.lambda$suppressNestedSecretsJson$3((List)y, excludeBrooklynDslExpressions, arg_0));
            return y;
        }
        throw new IllegalStateException("Non-JSON input received when not expected: " + x.getClass());
    }

    public static Sanitizer newInstance(Predicate<Object> sanitizingNeededCheck) {
        return new Sanitizer(sanitizingNeededCheck);
    }

    public static Sanitizer newInstance() {
        return Sanitizer.newInstance(IS_SECRET_PREDICATE);
    }

    public static Map<String, Object> sanitize(ConfigBag input) {
        return input == null ? null : Sanitizer.sanitize(input.getAllConfig());
    }

    public static <K> Map<K, Object> sanitize(Map<K, ?> input) {
        return input == null ? null : Sanitizer.sanitize(input, Sets.newHashSet());
    }

    static <K> Map<K, Object> sanitize(Map<K, ?> input, Set<Object> visited) {
        return input == null ? null : Sanitizer.newInstance().apply(input, visited);
    }

    private Sanitizer(Predicate<Object> sanitizingNeededCheck) {
        this.predicate = sanitizingNeededCheck;
    }

    public <K> K apply(K input) {
        return input == null ? null : (K)this.apply(input, Sets.newLinkedHashSet());
    }

    private <K> K apply(K input, Set<Object> visited) {
        if (input == null) {
            return null;
        }
        if (visited.contains(System.identityHashCode(input))) {
            return input;
        }
        visited.add(System.identityHashCode(input));
        if (input instanceof Map) {
            return (K)this.applyMap((Map)input, visited);
        }
        if (input instanceof List) {
            return (K)this.applyList((List)input, visited);
        }
        if (input instanceof Set) {
            return (K)this.applySet((Set)input, visited);
        }
        if (input instanceof String) {
            return (K)Sanitizer.sanitizeMultilineString((String)input);
        }
        if (input instanceof ConfigBag) {
            return (K)ConfigBag.newInstance(this.applyMap(((ConfigBag)input).getAllConfig(), visited));
        }
        return input;
    }

    private <K> Map<K, Object> applyMap(Map<K, ?> input, Set<Object> visited) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<K, ?> e : input.entrySet()) {
            if (e.getKey() != null && this.predicate.apply(e.getKey())) {
                result.put(e.getKey(), Sanitizer.suppress(e.getValue()));
                continue;
            }
            result.put(e.getKey(), this.apply(e.getValue(), visited));
        }
        return result;
    }

    private List<Object> applyIterable(Iterable<?> input, Set<Object> visited) {
        ArrayList result = Lists.newArrayList();
        for (Object o : input) {
            if (visited.contains(System.identityHashCode(o))) {
                result.add(o);
                continue;
            }
            visited.add(System.identityHashCode(o));
            if (o instanceof Map) {
                result.add(this.apply((Map)o, visited));
                continue;
            }
            if (o instanceof List) {
                result.add(this.applyList((List)o, visited));
                continue;
            }
            if (o instanceof Set) {
                result.add(this.applySet((Set)o, visited));
                continue;
            }
            result.add(o);
        }
        return result;
    }

    private List<Object> applyList(List<?> input, Set<Object> visited) {
        return this.applyIterable(input, visited);
    }

    private Set<Object> applySet(Set<?> input, Set<Object> visited) {
        return MutableSet.copyOf(this.applyIterable(input, visited));
    }

    private static /* synthetic */ void lambda$suppressNestedSecretsJson$3(List y, boolean excludeBrooklynDslExpressions, Object xi) {
        y.add(Sanitizer.suppressNestedSecretsJson(xi, excludeBrooklynDslExpressions));
    }

    private static /* synthetic */ void lambda$suppressNestedSecretsJson$2(Map y, boolean excludeBrooklynDslExpressions, Object k, Object v) {
        y.put(k, v != null && IS_SECRET_PREDICATE.apply(k) ? Sanitizer.suppressJson(v, excludeBrooklynDslExpressions) : Sanitizer.suppressNestedSecretsJson(v, excludeBrooklynDslExpressions));
    }

    private static class IsSecretPredicate
    implements Predicate<Object> {
        private IsSecretPredicate() {
        }

        public boolean apply(Object name) {
            if (name == null) {
                return false;
            }
            if (name instanceof Secret) {
                return true;
            }
            String lowerName = name.toString().toLowerCase();
            for (String secretName : Sanitizer.getSensitiveFieldsTokens()) {
                if (!lowerName.contains(secretName)) continue;
                return true;
            }
            return false;
        }
    }
}

