/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteEntityWorkflowStep
extends WorkflowStepDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteEntityWorkflowStep.class);
    public static final String SHORTHAND = "[ ${entity} ]";
    public static final ConfigKey<Object> ENTITY = ConfigKeys.newConfigKey(Object.class, "entity");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        if (!this.getInput().containsKey(ENTITY.getName())) {
            throw new IllegalArgumentException("Missing required argument: " + ENTITY.getName());
        }
    }

    @Override
    protected String getStepState(WorkflowStepInstanceExecutionContext context) {
        return (String)super.getStepState(context);
    }

    void setStepState(WorkflowStepInstanceExecutionContext context, String foundEntityId) {
        context.setStepState(foundEntityId, true);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        String entityId = this.getStepState(context);
        Entity entity = null;
        if (entityId == null) {
            entity = (Entity)WorkflowStepResolution.findEntity(context, context.getInput(ENTITY)).get();
            entityId = entity.getId();
            this.setStepState(context, entityId);
        }
        if (entity == null) {
            entity = context.getManagementContext().getEntityManager().getEntity(entityId);
        }
        if (entity == null || Entities.isUnmanagingOrNoLongerManaged(entity)) {
            LOG.debug("Entity '" + entityId + "' already unmanaged.");
        } else {
            Entities.unmanage(entity);
        }
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

