/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.brooklyn.core.workflow.ShorthandProcessor;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.guava.Maybe;

public class TransformReplace
extends WorkflowTransformDefault {
    boolean regex;
    boolean glob;
    boolean literal;
    boolean all;
    String patternToMatch;
    String replacement;
    String SHORTHAND = "\"replace\" [ ?${all} \"all\" ] [ ?${regex} \"regex\" ] [ ?${glob} \"glob\" ] [ ?${literal} \"literal\" ] ${patternToMatch} ${replacement}";

    @Override
    protected void initCheckingDefinition() {
        Maybe<Map<String, Object>> maybeResult = new ShorthandProcessor(this.SHORTHAND).withFinalMatchRaw(false).withFailOnMismatch(true).process(this.transformDef);
        if (maybeResult.isPresent()) {
            Map result = (Map)maybeResult.get();
            this.all = Boolean.TRUE.equals(result.get("all"));
            this.regex = Boolean.TRUE.equals(result.get("regex"));
            this.glob = Boolean.TRUE.equals(result.get("glob"));
            this.literal = Boolean.TRUE.equals(result.get("literal"));
            this.patternToMatch = String.valueOf(result.get("patternToMatch"));
            this.replacement = String.valueOf(result.get("replacement"));
            int replaceTypeCount = (this.regex ? 1 : 0) + (this.glob ? 1 : 0) + (this.literal ? 1 : 0);
            if (replaceTypeCount > 1) {
                throw new IllegalArgumentException("Only one of regex, glob, and literal can be set");
            }
            if (replaceTypeCount == 0) {
                this.literal = true;
            }
        } else {
            throw new IllegalArgumentException("Expression must be of the form 'replace [all] [regex|glob|literal] patternToMatch replacement'");
        }
    }

    public Object apply(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Expression must be of the form replace [regex|glob|literal] pattern_to_match replacement");
        }
        String input = (String)o;
        if (this.regex) {
            return this.all ? input.replaceAll(this.patternToMatch, this.replacement) : input.replaceFirst(this.patternToMatch, this.replacement);
        }
        if (this.glob) {
            String globToRegex = this.convertGlobToRegex(this.patternToMatch, !this.all);
            return this.all ? input.replaceAll(globToRegex, this.replacement) : input.replaceFirst(globToRegex, this.replacement);
        }
        if (this.literal) {
            return this.all ? Pattern.compile(this.patternToMatch, 16).matcher(input).replaceAll(this.replacement) : Pattern.compile(this.patternToMatch, 16).matcher(input).replaceFirst(this.replacement);
        }
        throw new IllegalArgumentException("Expression must be of the form replace [regex|glob|literal] pattern_to_match replacement");
    }

    private String convertGlobToRegex(String pattern, boolean isGreedy) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*" + (isGreedy ? "" : "?"));
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

