/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.brooklynnode.BrooklynClusterImpl;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.effector.BrooklynNodeUpgradeEffectorBody;
import org.apache.brooklyn.entity.group.DynamicCluster;

@ImplementedBy(value=BrooklynClusterImpl.class)
public interface BrooklynCluster
extends DynamicCluster {
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKeyWithDefault((ConfigKey)DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(BrooklynNode.class));
    public static final AttributeSensor<BrooklynNode> MASTER_NODE = Sensors.newSensor(BrooklynNode.class, (String)"brooklyncluster.master", (String)"Pointer to the child node with MASTER state in the cluster");
    public static final Effector<Void> SELECT_MASTER = SelectMasterEffector.SELECT_MASTER;
    public static final Effector<Void> UPGRADE_CLUSTER = UpgradeClusterEffector.UPGRADE_CLUSTER;

    public static interface UpgradeClusterEffector {
        public static final ConfigKey<String> DOWNLOAD_URL = BrooklynNode.DOWNLOAD_URL.getConfigKey();
        public static final ConfigKey<Map<String, Object>> EXTRA_CONFIG = BrooklynNodeUpgradeEffectorBody.EXTRA_CONFIG;
        public static final Effector<Void> UPGRADE_CLUSTER = Effectors.effector(Void.class, (String)"upgradeCluster").description("Upgrade the cluster with new distribution version, by provisioning new nodes with the new version, failing over, and then deprovisioning the original nodes").parameter(BrooklynNode.SUGGESTED_VERSION).parameter(DOWNLOAD_URL).parameter(EXTRA_CONFIG).buildAbstract();
    }

    public static interface SelectMasterEffector {
        public static final ConfigKey<String> NEW_MASTER_ID = ConfigKeys.newStringConfigKey((String)"brooklyncluster.new_master_id", (String)"The ID of the node to become master", null);
        public static final Effector<Void> SELECT_MASTER = Effectors.effector(Void.class, (String)"selectMaster").description("Select a new master in the cluster").parameter(NEW_MASTER_ID).buildAbstract();
    }
}

