/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.xml;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.internal.BlobPropertiesImpl;
import org.jclouds.azureblob.domain.internal.HashSetListBlobsResponse;
import org.jclouds.date.DateService;
import org.jclouds.http.Uris;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.util.Strings2;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ContainerNameEnumerationResultsHandler
extends ParseSax.HandlerWithResult<ListBlobsResponse> {
    private Set<BlobProperties> blobMetadata = Sets.newLinkedHashSet();
    private String prefix;
    private String marker;
    private int maxResults;
    private String nextMarker;
    private URI containerUrl;
    private Date currentLastModified;
    private String currentETag;
    private StringBuilder currentText = new StringBuilder();
    private final DateService dateParser;
    private final ContentMetadataCodec contentMetadataCodec;
    private String delimiter;
    private String currentName;
    private long currentSize;
    private String currentContentType;
    private String currentContentEncoding;
    private String currentContentLanguage;
    private BlobType currentBlobType;
    private AccessTier currentAccessTier;
    private Date currentExpires;
    private boolean inBlob;
    private boolean inBlobPrefix;
    private boolean inMetadata;
    private Set<String> blobPrefixes = Sets.newHashSet();
    private byte[] currentContentMD5;
    private Map<String, String> currentMetadata = Maps.newHashMap();
    private LeaseStatus currentLeaseStatus;

    @Inject
    public ContainerNameEnumerationResultsHandler(DateService dateParser, ContentMetadataCodec contentMetadataCodec) {
        this.dateParser = dateParser;
        this.contentMetadataCodec = contentMetadataCodec;
    }

    public ListBlobsResponse getResult() {
        return new HashSetListBlobsResponse(this.blobMetadata, this.containerUrl, this.prefix, this.marker, this.maxResults, this.nextMarker, this.delimiter, this.blobPrefixes);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Blob")) {
            this.inBlob = true;
            this.inBlobPrefix = false;
            this.inMetadata = false;
        } else if (qName.equals("BlobPrefix")) {
            this.inBlob = false;
            this.inBlobPrefix = true;
        } else if (qName.equals("Metadata")) {
            this.inBlob = true;
            this.inMetadata = true;
        } else if (qName.equals("EnumerationResults")) {
            this.containerUrl = URI.create(attributes.getValue("ServiceEndpoint").trim() + attributes.getValue("ContainerName").trim());
        }
        this.currentText.setLength(0);
    }

    public void endElement(String uri, String name, String qName) {
        if (this.inMetadata && !qName.equals("Metadata")) {
            this.currentMetadata.put(qName, this.currentText.toString());
        } else if (qName.equals("Metadata")) {
            this.inMetadata = false;
        } else if (qName.equals("MaxResults")) {
            this.maxResults = Integer.parseInt(this.currentText.toString());
        } else if (qName.equals("Marker")) {
            this.marker = this.currentText.toString();
            this.marker = this.marker.equals("") ? null : this.marker;
        } else if (qName.equals("Prefix")) {
            this.prefix = this.currentText.toString();
            this.prefix = this.prefix.equals("") ? null : this.prefix;
        } else if (qName.equals("Delimiter")) {
            this.delimiter = this.currentText.toString();
            this.delimiter = this.delimiter.equals("") ? null : this.delimiter;
        } else if (qName.equals("NextMarker")) {
            this.nextMarker = this.currentText.toString();
            this.nextMarker = this.nextMarker.equals("") ? null : this.nextMarker;
        } else if (qName.equals("BlobType")) {
            this.currentBlobType = BlobType.fromValue(this.currentText.toString());
        } else if (qName.equals("AccessTier")) {
            this.currentAccessTier = AccessTier.fromValue(this.currentText.toString());
        } else if (qName.equals("LeaseStatus")) {
            this.currentLeaseStatus = LeaseStatus.fromValue(this.currentText.toString());
        } else if (qName.equals("Blob")) {
            URI currentUrl = Uris.uriBuilder((URI)this.containerUrl).appendPath(Strings2.urlEncode((String)this.currentName, (char[])new char[0])).build();
            BlobPropertiesImpl md = new BlobPropertiesImpl(this.currentBlobType, this.currentAccessTier, this.currentName, this.containerUrl.getPath().replace("/", ""), currentUrl, this.currentLastModified, this.currentETag, this.currentSize, this.currentContentType, this.currentContentMD5, this.currentContentEncoding, this.currentContentLanguage, this.currentExpires, this.currentLeaseStatus, this.currentMetadata);
            this.blobMetadata.add(md);
            this.currentBlobType = null;
            this.currentAccessTier = null;
            this.currentName = null;
            this.currentLastModified = null;
            this.currentETag = null;
            this.currentSize = -1L;
            this.currentContentType = null;
            this.currentContentEncoding = null;
            this.currentContentLanguage = null;
            this.currentContentMD5 = null;
            this.currentLeaseStatus = null;
            this.currentExpires = null;
            this.currentMetadata = Maps.newHashMap();
        } else if (qName.equals("Last-Modified")) {
            this.currentLastModified = this.dateParser.rfc822DateParse(this.currentText.toString());
        } else if (qName.equals("Etag")) {
            this.currentETag = this.currentText.toString();
        } else if (qName.equals("Name")) {
            if (this.inBlob) {
                this.currentName = this.currentText.toString();
            } else if (this.inBlobPrefix) {
                this.blobPrefixes.add(this.currentText.toString());
            }
        } else if (qName.equals("Content-Length")) {
            this.currentSize = Long.parseLong(this.currentText.toString());
        } else if (qName.equals("Content-MD5")) {
            if (!this.currentText.toString().equals("")) {
                this.currentContentMD5 = BaseEncoding.base64().decode((CharSequence)this.currentText.toString());
            }
        } else if (qName.equals("Content-Type")) {
            this.currentContentType = this.currentText.toString();
        } else if (qName.equals("Content-Encoding")) {
            this.currentContentEncoding = this.currentText.toString();
            if (this.currentContentEncoding.equals("")) {
                this.currentContentEncoding = null;
            }
        } else if (qName.equals("Content-Language")) {
            this.currentContentLanguage = this.currentText.toString();
            if (this.currentContentLanguage.equals("")) {
                this.currentContentLanguage = null;
            }
        } else if (qName.equals("Expires")) {
            String expiration = this.currentText.toString();
            this.currentExpires = expiration.equals("") ? null : this.contentMetadataCodec.parseExpires(expiration);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

