/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import org.apache.karaf.jpm.Process;
import org.apache.karaf.jpm.impl.ProcessBuilderFactoryImpl;
import org.apache.karaf.main.ConfigProperties;

public class Status {
    private static final String RUNNING = "Running ...";
    private static final String NOT_RUNNING = "Not Running ...";

    public static void main(String[] args) throws Exception {
        ConfigProperties config = new ConfigProperties();
        if (config.shutdownPort == 0 && config.portFile != null) {
            try {
                config.shutdownPort = Status.getPortFromShutdownPortFile(config.portFile);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(NOT_RUNNING);
                System.exit(3);
            }
            catch (IOException ioe) {
                System.out.println(NOT_RUNNING);
                System.exit(4);
            }
        }
        if (config.shutdownPort > 0) {
            try (Socket s = new Socket(config.shutdownHost, config.shutdownPort);){
                if (s.isBound()) {
                    System.out.println(RUNNING);
                    System.exit(0);
                } else {
                    System.out.println(NOT_RUNNING);
                    System.exit(1);
                }
            }
            catch (ConnectException connectException) {
                System.out.println(NOT_RUNNING);
                System.exit(1);
            }
        } else {
            int pid = Status.getPidFromPidFile(config.pidFile);
            Process process = new ProcessBuilderFactoryImpl().newBuilder().attach(pid);
            if (process.isRunning()) {
                System.out.println("Running ... (pid " + pid + ")");
                System.exit(0);
            } else {
                System.out.println(NOT_RUNNING);
                System.exit(1);
            }
        }
    }

    private static int getPortFromShutdownPortFile(String portFile) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
        String portStr = r.readLine();
        int port = Integer.parseInt(portStr);
        r.close();
        return port;
    }

    private static int getPidFromPidFile(String pidFile) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(pidFile)));
        String pidString = r.readLine();
        int pid = Integer.parseInt(pidString);
        r.close();
        return pid;
    }
}

