/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class DataBag
extends ForwardingMap<String, String> {
    private String name;
    private Map<String, String> items;

    public static Builder builder() {
        return new Builder();
    }

    public DataBag(String name, Map<String, String> items) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name must be set");
        this.items = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(items, (Object)"items must be set")));
    }

    protected Map<String, String> delegate() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getItems() {
        return this.items;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataBag other = (DataBag)((Object)obj);
        return Objects.equal((Object)this.name, (Object)other.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).toString();
    }

    public static class Builder {
        private String name;
        private ImmutableMap.Builder<String, String> items = ImmutableMap.builder();

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name must be set");
            return this;
        }

        public Builder item(String name, String jsonData) {
            this.items.put((Object)((String)Preconditions.checkNotNull((Object)name, (Object)"name must be set")), (Object)((String)Preconditions.checkNotNull((Object)jsonData, (Object)"jsonData must be set")));
            return this;
        }

        public Builder items(Map<String, String> items) {
            this.items.putAll((Map)Preconditions.checkNotNull(items, (Object)"items must be set"));
            return this;
        }

        public DataBag build() {
            return new DataBag(this.name, (Map<String, String>)this.items.build());
        }
    }
}

