/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;

@Beta
public class MultimapSerializer
extends StdSerializer<Multimap<?, ?>> {
    protected MultimapSerializer() {
        super(Multimap.class);
    }

    public void serialize(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        this.writeEntries(value, jgen, provider);
        jgen.writeEndObject();
    }

    private void writeEntries(Multimap<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        for (Map.Entry entry : value.asMap().entrySet()) {
            provider.findKeySerializer(provider.constructType(Object.class), null).serialize(entry.getKey(), jgen, provider);
            provider.defaultSerializeValue((Object)Lists.newArrayList((Iterable)((Iterable)entry.getValue())), jgen);
        }
    }
}

