/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilestatus.traits.Jolokia;
import org.apache.camel.v1.integrationprofilestatus.traits.jolokia.Configuration;
import org.apache.camel.v1.integrationprofilestatus.traits.jolokia.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.jolokia.ConfigurationFluent;

public class JolokiaFluent<A extends JolokiaFluent<A>>
extends BaseFluent<A> {
    private String CACert;
    private List<String> clientPrincipal;
    private ConfigurationBuilder configuration;
    private Boolean discoveryEnabled;
    private Boolean enabled;
    private Boolean extendedClientCheck;
    private String host;
    private List<String> options;
    private String password;
    private Long port;
    private String protocol;
    private Boolean useSSLClientAuthentication;
    private String user;

    public JolokiaFluent() {
    }

    public JolokiaFluent(Jolokia instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Jolokia instance) {
        Jolokia jolokia = instance = instance != null ? instance : new Jolokia();
        if (instance != null) {
            this.withCACert(instance.getCACert());
            this.withClientPrincipal(instance.getClientPrincipal());
            this.withConfiguration(instance.getConfiguration());
            this.withDiscoveryEnabled(instance.getDiscoveryEnabled());
            this.withEnabled(instance.getEnabled());
            this.withExtendedClientCheck(instance.getExtendedClientCheck());
            this.withHost(instance.getHost());
            this.withOptions(instance.getOptions());
            this.withPassword(instance.getPassword());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withUseSSLClientAuthentication(instance.getUseSSLClientAuthentication());
            this.withUser(instance.getUser());
        }
    }

    public String getCACert() {
        return this.CACert;
    }

    public A withCACert(String CACert) {
        this.CACert = CACert;
        return (A)((Object)this);
    }

    public boolean hasCACert() {
        return this.CACert != null;
    }

    public A addToClientPrincipal(int index, String item) {
        if (this.clientPrincipal == null) {
            this.clientPrincipal = new ArrayList<String>();
        }
        this.clientPrincipal.add(index, item);
        return (A)((Object)this);
    }

    public A setToClientPrincipal(int index, String item) {
        if (this.clientPrincipal == null) {
            this.clientPrincipal = new ArrayList<String>();
        }
        this.clientPrincipal.set(index, item);
        return (A)((Object)this);
    }

    public A addToClientPrincipal(String ... items) {
        if (this.clientPrincipal == null) {
            this.clientPrincipal = new ArrayList<String>();
        }
        for (String item : items) {
            this.clientPrincipal.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToClientPrincipal(Collection<String> items) {
        if (this.clientPrincipal == null) {
            this.clientPrincipal = new ArrayList<String>();
        }
        for (String item : items) {
            this.clientPrincipal.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromClientPrincipal(String ... items) {
        if (this.clientPrincipal == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clientPrincipal.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromClientPrincipal(Collection<String> items) {
        if (this.clientPrincipal == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.clientPrincipal.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getClientPrincipal() {
        return this.clientPrincipal;
    }

    public String getClientPrincipal(int index) {
        return this.clientPrincipal.get(index);
    }

    public String getFirstClientPrincipal() {
        return this.clientPrincipal.get(0);
    }

    public String getLastClientPrincipal() {
        return this.clientPrincipal.get(this.clientPrincipal.size() - 1);
    }

    public String getMatchingClientPrincipal(Predicate<String> predicate) {
        for (String item : this.clientPrincipal) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingClientPrincipal(Predicate<String> predicate) {
        for (String item : this.clientPrincipal) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClientPrincipal(List<String> clientPrincipal) {
        if (clientPrincipal != null) {
            this.clientPrincipal = new ArrayList<String>();
            for (String item : clientPrincipal) {
                this.addToClientPrincipal(item);
            }
        } else {
            this.clientPrincipal = null;
        }
        return (A)((Object)this);
    }

    public A withClientPrincipal(String ... clientPrincipal) {
        if (this.clientPrincipal != null) {
            this.clientPrincipal.clear();
            this._visitables.remove((Object)"clientPrincipal");
        }
        if (clientPrincipal != null) {
            for (String item : clientPrincipal) {
                this.addToClientPrincipal(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClientPrincipal() {
        return this.clientPrincipal != null && !this.clientPrincipal.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public A withDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
        return (A)((Object)this);
    }

    public boolean hasDiscoveryEnabled() {
        return this.discoveryEnabled != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getExtendedClientCheck() {
        return this.extendedClientCheck;
    }

    public A withExtendedClientCheck(Boolean extendedClientCheck) {
        this.extendedClientCheck = extendedClientCheck;
        return (A)((Object)this);
    }

    public boolean hasExtendedClientCheck() {
        return this.extendedClientCheck != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)((Object)this);
    }

    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)((Object)this);
    }

    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<String> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public Long getPort() {
        return this.port;
    }

    public A withPort(Long port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)((Object)this);
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public Boolean getUseSSLClientAuthentication() {
        return this.useSSLClientAuthentication;
    }

    public A withUseSSLClientAuthentication(Boolean useSSLClientAuthentication) {
        this.useSSLClientAuthentication = useSSLClientAuthentication;
        return (A)((Object)this);
    }

    public boolean hasUseSSLClientAuthentication() {
        return this.useSSLClientAuthentication != null;
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user = user;
        return (A)((Object)this);
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JolokiaFluent that = (JolokiaFluent)((Object)o);
        if (!Objects.equals(this.CACert, that.CACert)) {
            return false;
        }
        if (!Objects.equals(this.clientPrincipal, that.clientPrincipal)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.discoveryEnabled, that.discoveryEnabled)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.extendedClientCheck, that.extendedClientCheck)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        if (!Objects.equals(this.useSSLClientAuthentication, that.useSSLClientAuthentication)) {
            return false;
        }
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.CACert, this.clientPrincipal, this.configuration, this.discoveryEnabled, this.enabled, this.extendedClientCheck, this.host, this.options, this.password, this.port, this.protocol, this.useSSLClientAuthentication, this.user, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.CACert != null) {
            sb.append("CACert:");
            sb.append(this.CACert + ",");
        }
        if (this.clientPrincipal != null && !this.clientPrincipal.isEmpty()) {
            sb.append("clientPrincipal:");
            sb.append(this.clientPrincipal + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.discoveryEnabled != null) {
            sb.append("discoveryEnabled:");
            sb.append(this.discoveryEnabled + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.extendedClientCheck != null) {
            sb.append("extendedClientCheck:");
            sb.append(this.extendedClientCheck + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol + ",");
        }
        if (this.useSSLClientAuthentication != null) {
            sb.append("useSSLClientAuthentication:");
            sb.append(this.useSSLClientAuthentication + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDiscoveryEnabled() {
        return this.withDiscoveryEnabled(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withExtendedClientCheck() {
        return this.withExtendedClientCheck(true);
    }

    public A withUseSSLClientAuthentication() {
        return this.withUseSSLClientAuthentication(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)JolokiaFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

