/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache.invalidation;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.cache.invalidation.CacheGroupsHandler;
import org.apache.cayenne.cache.invalidation.CacheInvalidationModule;
import org.apache.cayenne.cache.invalidation.InvalidationFunction;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;

public class CacheInvalidationModuleExtender {
    private Collection<Class<? extends InvalidationHandler>> handlerTypes = new HashSet<Class<? extends InvalidationHandler>>();
    private Collection<InvalidationHandler> handlerInstances = new HashSet<InvalidationHandler>();
    private boolean noCacheGroupsHandler;

    CacheInvalidationModuleExtender() {
    }

    public CacheInvalidationModuleExtender noCacheGroupsHandler() {
        this.noCacheGroupsHandler = true;
        return this;
    }

    public CacheInvalidationModuleExtender addHandler(Class<? extends InvalidationHandler> handlerType) {
        this.handlerTypes.add(handlerType);
        return this;
    }

    public CacheInvalidationModuleExtender addHandler(InvalidationHandler handlerInstance) {
        this.handlerInstances.add(handlerInstance);
        return this;
    }

    public Module module() {
        return new Module(){

            public void configure(Binder binder) {
                if (CacheInvalidationModuleExtender.this.noCacheGroupsHandler) {
                    binder.bind(CacheGroupsHandler.class).toInstance((Object)new CacheGroupsHandler(){

                        @Override
                        public InvalidationFunction canHandle(Class<? extends Persistent> type) {
                            return null;
                        }
                    });
                }
                ListBuilder<InvalidationHandler> handlers = CacheInvalidationModule.contributeInvalidationHandler(binder);
                handlers.addAll(CacheInvalidationModuleExtender.this.handlerInstances);
                for (Class handlerType : CacheInvalidationModuleExtender.this.handlerTypes) {
                    handlers.add(handlerType);
                }
            }
        };
    }
}

