/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyUtils;

public class Cayenne {
    static final String PROPERTY_COLLECTION_SIZE = "@size";

    public static ObjEntity getObjEntity(Persistent p) {
        return p.getObjectContext() != null ? p.getObjectContext().getEntityResolver().getObjEntity(p) : null;
    }

    public static ClassDescriptor getClassDescriptor(Persistent object) {
        ObjectContext context = object.getObjectContext();
        if (context == null) {
            return null;
        }
        return context.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
    }

    public static PropertyDescriptor getProperty(Persistent object, String properyName) {
        ClassDescriptor descriptor = Cayenne.getClassDescriptor(object);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getProperty(properyName);
    }

    public static Object readNestedProperty(Object o, String path) {
        if (o == null) {
            return null;
        }
        if (o instanceof DataObject) {
            return ((DataObject)o).readNestedProperty(path);
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            if (path.equals(PROPERTY_COLLECTION_SIZE)) {
                return collection.size();
            }
            AbstractCollection result = o instanceof List ? new ArrayList() : new HashSet();
            for (Object item : collection) {
                if (!(item instanceof DataObject)) continue;
                DataObject cdo = (DataObject)item;
                Object rest = cdo.readNestedProperty(path);
                if (rest instanceof Collection) {
                    result.addAll((Collection)rest);
                    continue;
                }
                result.add(rest);
            }
            return result;
        }
        if (null == path || 0 == path.length()) {
            throw new IllegalArgumentException("the path must be supplied in order to lookup a nested property");
        }
        int dotIndex = path.indexOf(46);
        if (0 == dotIndex) {
            throw new IllegalArgumentException("the path is invalid because it starts with a period character");
        }
        if (dotIndex == path.length() - 1) {
            throw new IllegalArgumentException("the path is invalid because it ends with a period character");
        }
        if (-1 == dotIndex) {
            return Cayenne.readSimpleProperty(o, path);
        }
        String path0 = path.substring(0, dotIndex);
        String pathRemainder = path.substring(dotIndex + 1);
        if ('+' == path0.charAt(path0.length() - 1)) {
            path0 = path0.substring(0, path0.length() - 1);
        }
        Object property = Cayenne.readSimpleProperty(o, path0);
        return Cayenne.readNestedProperty(property, pathRemainder);
    }

    private static final Object readSimpleProperty(Object o, String propertyName) {
        PropertyDescriptor property;
        if (o instanceof Persistent && (property = Cayenne.getProperty((Persistent)o, propertyName)) != null) {
            return property.readProperty(o);
        }
        return PropertyUtils.getProperty(o, propertyName);
    }

    public static String makePath(String ... pathParts) {
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (String path : pathParts) {
            builder.append(separator).append(path);
            separator = ".";
        }
        return builder.toString();
    }

    public static long longPKForObject(Persistent dataObject) {
        Object value = Cayenne.pkForObject(dataObject);
        if (!(value instanceof Number)) {
            throw new CayenneRuntimeException("PK is not a number: %s", dataObject.getObjectId());
        }
        return ((Number)value).longValue();
    }

    public static int intPKForObject(Persistent dataObject) {
        Object value = Cayenne.pkForObject(dataObject);
        if (!(value instanceof Number)) {
            throw new CayenneRuntimeException("PK is not a number: %s", dataObject.getObjectId());
        }
        return ((Number)value).intValue();
    }

    public static Object pkForObject(Persistent dataObject) {
        Map<String, Object> pk = Cayenne.extractObjectId(dataObject);
        if (pk.size() != 1) {
            throw new CayenneRuntimeException("Expected single column PK, got %d columns, ID: %s", pk.size(), pk);
        }
        return pk.entrySet().iterator().next().getValue();
    }

    public static Map<String, Object> compoundPKForObject(Persistent dataObject) {
        return Collections.unmodifiableMap(Cayenne.extractObjectId(dataObject));
    }

    static Map<String, Object> extractObjectId(Persistent dataObject) {
        DbEntity entity;
        ObjEntity objEntity;
        if (dataObject == null) {
            throw new IllegalArgumentException("Null DataObject");
        }
        ObjectId id = dataObject.getObjectId();
        if (!id.isTemporary()) {
            return id.getIdSnapshot();
        }
        if (id.isReplacementIdAttached() && (objEntity = dataObject.getObjectContext().getEntityResolver().getObjEntity(dataObject)) != null && (entity = objEntity.getDbEntity()) != null && entity.isFullReplacementIdAttached(id)) {
            return id.getReplacementIdMap();
        }
        throw new CayenneRuntimeException("Can't get primary key from temporary id.", new Object[0]);
    }

    public static <T> T objectForPK(ObjectContext context, Class<T> dataObjectClass, int pk) {
        return (T)Cayenne.objectForPK(context, Cayenne.buildId(context, dataObjectClass, (Object)pk));
    }

    public static <T> T objectForPK(ObjectContext context, Class<T> dataObjectClass, Object pk) {
        return (T)Cayenne.objectForPK(context, Cayenne.buildId(context, dataObjectClass, pk));
    }

    public static <T> T objectForPK(ObjectContext context, Class<T> dataObjectClass, Map<String, ?> pk) {
        ObjEntity entity = context.getEntityResolver().getObjEntity(dataObjectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Non-existent ObjEntity for class: %s", dataObjectClass);
        }
        return (T)Cayenne.objectForPK(context, new ObjectId(entity.getName(), pk));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, int pk) {
        return Cayenne.objectForPK(context, Cayenne.buildId(context, objEntityName, (Object)pk));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, Object pk) {
        return Cayenne.objectForPK(context, Cayenne.buildId(context, objEntityName, pk));
    }

    public static Object objectForPK(ObjectContext context, String objEntityName, Map<String, ?> pk) {
        if (objEntityName == null) {
            throw new IllegalArgumentException("Null ObjEntity name.");
        }
        return Cayenne.objectForPK(context, new ObjectId(objEntityName, pk));
    }

    public static Object objectForPK(ObjectContext context, ObjectId id) {
        return Cayenne.objectForQuery(context, new ObjectIdQuery(id, false, 1));
    }

    public static Object objectForQuery(ObjectContext context, Query query) {
        List objects = context.performQuery(query);
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: %d", objects.size());
        }
        return objects.get(0);
    }

    static ObjectId buildId(ObjectContext context, String objEntityName, Object pk) {
        if (pk == null) {
            throw new IllegalArgumentException("Null PK");
        }
        if (objEntityName == null) {
            throw new IllegalArgumentException("Null ObjEntity name.");
        }
        ObjEntity entity = context.getEntityResolver().getObjEntity(objEntityName);
        if (entity == null) {
            throw new CayenneRuntimeException("Non-existent ObjEntity: %s", objEntityName);
        }
        Collection<String> pkAttributes = entity.getPrimaryKeyNames();
        if (pkAttributes.size() != 1) {
            throw new CayenneRuntimeException("PK contains %d columns, expected 1.", pkAttributes.size());
        }
        String attr = pkAttributes.iterator().next();
        return new ObjectId(objEntityName, attr, pk);
    }

    static ObjectId buildId(ObjectContext context, Class<?> dataObjectClass, Object pk) {
        if (pk == null) {
            throw new IllegalArgumentException("Null PK");
        }
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Null DataObject class.");
        }
        ObjEntity entity = context.getEntityResolver().getObjEntity(dataObjectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped DataObject Class: %s", dataObjectClass.getName());
        }
        Collection<String> pkAttributes = entity.getPrimaryKeyNames();
        if (pkAttributes.size() != 1) {
            throw new CayenneRuntimeException("PK contains %d columns, expected 1.", pkAttributes.size());
        }
        String attr = pkAttributes.iterator().next();
        return new ObjectId(entity.getName(), attr, pk);
    }

    protected Cayenne() {
    }
}

