/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardModeController;
import org.apache.cayenne.modeler.dialog.codegen.StandardModePanel;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public class ClientModeController
extends StandardModeController {
    protected Predicate checkPredicate;

    public ClientModeController(CodeGeneratorControllerBase parent) {
        super(parent);
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity) {
        if (!entity.isClientAllowed()) {
            validationBuffer.addFailure(new BeanValidationFailure(entity.getName(), "clientAllowed", "Not a client entity"));
        } else {
            super.validateEntity(validationBuffer, entity, true);
        }
    }

    @Override
    protected void createDefaults() {
        TreeMap<DataMap, DataMapDefaults> map = new TreeMap<DataMap, DataMapDefaults>();
        ArrayList dataMaps = (ArrayList)this.getParentController().getDataMaps();
        for (DataMap dataMap : dataMaps) {
            DataMapDefaults preferences = this.getApplication().getFrameController().getProjectController().getDataMapPreferences(this.getClass().getName().replace(".", "/"), dataMap);
            preferences.setSuperclassPackage("");
            preferences.updateSuperclassPackage(dataMap, true);
            map.put(dataMap, preferences);
            if (this.getOutputPath() != null) continue;
            this.setOutputPath(preferences.getOutputPath());
        }
        this.setMapPreferences(map);
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new StandardModePanel();
        return this.view;
    }

    @Override
    protected ClassGenerationAction newGenerator() {
        return new ClientClassGenerationAction();
    }
}

